/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.formedittextvalidator;

import android.widget.EditText;
import com.andreabaccega.formedittextvalidator.Validator;

public class FloatNumericRangeValidator
extends Validator {
    private float floatmin;
    private float floatmax;

    public FloatNumericRangeValidator(String _customErrorMessage, float floatmin, float floatmax) {
        super(_customErrorMessage);
        this.floatmin = floatmin;
        this.floatmax = floatmax;
    }

    @Override
    public boolean isValid(EditText et) {
        try {
            float value = Float.parseFloat(et.getText().toString());
            return value >= this.floatmin && value <= this.floatmax;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

