/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.formedittextvalidator;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.widget.EditText;
import com.andreabaccega.formedittextvalidator.Validator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateValidator
extends Validator {
    private String[] formats;

    public DateValidator(String _customErrorMessage, String _format) {
        super(_customErrorMessage);
        String[] stringArray;
        if (TextUtils.isEmpty((CharSequence)_format)) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "DefaultDate";
            stringArray2[1] = "DefaultTime";
            stringArray = stringArray2;
            stringArray2[2] = "DefaultDateTime";
        } else {
            stringArray = _format.split(";");
        }
        this.formats = stringArray;
    }

    @Override
    @SuppressLint(value={"SimpleDateFormat"})
    public boolean isValid(EditText et) {
        if (TextUtils.isEmpty((CharSequence)et.getText())) {
            return true;
        }
        String value = et.getText().toString();
        for (String _format : this.formats) {
            DateFormat format = "DefaultDate".equalsIgnoreCase(_format) ? SimpleDateFormat.getDateInstance() : ("DefaultTime".equalsIgnoreCase(_format) ? SimpleDateFormat.getTimeInstance() : ("DefaultDateTime".equalsIgnoreCase(_format) ? SimpleDateFormat.getDateTimeInstance() : new SimpleDateFormat(_format)));
            Date date = null;
            try {
                date = format.parse(value);
            }
            catch (ParseException e) {
                return false;
            }
            if (date == null) continue;
            return true;
        }
        return false;
    }
}

