/*
 * Decompiled with CFR 0.152.
 */
package com.anagog.jedai.debugging;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.documentfile.provider.DocumentFile;
import com.anagog.jedai.common.JedAIApi;
import com.anagog.jedai.common.playback.PlaybackConfig;
import com.anagog.jedai.common.playback.PlaybackStateListener;
import com.anagog.jedai.core.api.JedAI;
import com.anagog.jedai.core.api.JedAIApiInternal;
import com.anagog.jedai.core.api.JedAIApiWrapperThreadSafe;
import com.anagog.jedai.core.common.FileUtils;
import com.anagog.jedai.core.logger.JedAILogger;
import com.anagog.jedai.debugging.DebuggingFileProvider;
import com.anagog.jedai.debugging.DebuggingImportProvider;
import com.anagog.jedai.debugging.R;
import com.anagog.jedai.debugging.files.JedAIFileProvider;
import com.anagog.jedai.debugging.jema_debug.common.SharedPreferencesCommonUtils;
import com.anagog.jedai.debugging.playback.PlaybackUtils;
import com.anagog.jedai.debugging.zip.DebuggingDataZipConfig;
import com.anagog.jedai.debugging.zip.DebuggingDataZipProvider;
import com.anagog.jedai.jema.JedAIJema;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;

public class JedAIDebugging {
    private static final JedAILogger sLogger = JedAILogger.getLogger((String)JedAIDebugging.class.getName());
    private static final String TEMP_DIRECTORY = "debugging_tmp";
    private static final String TEMP_UNZIP_DIR = "com.anagog.jedai.debugging.unzip";
    private static final String KEY_PLAYBACK_CONFIG = "playback_config";
    private static final String APP_PREFERENCES_PLAYBACK = "App_Pref_Playback";
    private static Context sAppContext;
    private static String sAppID;
    private static JedAIApi sJedAIApi;
    @NonNull
    private static PlaybackConfig sPlaybackConfig;
    private static JedAIDebugging sInstance;
    private final DebuggingDataZipProvider mZipProvider;

    public static JedAIDebugging getInstance() {
        if (sInstance == null) {
            sInstance = new JedAIDebugging();
        }
        return sInstance;
    }

    public static void setup(@NonNull Context context) {
        JedAI jedAIApi = JedAI.getInstance();
        if (jedAIApi == null) {
            throw new IllegalStateException("You must initialize JedAI before instance claiming");
        }
        JedAIDebugging.setup(context, (JedAIApi)jedAIApi);
    }

    public static void setup(@NonNull Context context, @NonNull JedAIApi jedAIApi) {
        sAppContext = context.getApplicationContext();
        sAppID = sAppContext.getPackageName();
        sJedAIApi = jedAIApi;
    }

    private JedAIDebugging() {
        JedAIFileProvider fileProvider = new JedAIFileProvider(sAppContext);
        JedAIApiWrapperThreadSafe jedAIApiInternal = JedAIApiWrapperThreadSafe.getInstance();
        this.mZipProvider = new DebuggingDataZipProvider(fileProvider, (JedAIApiInternal)jedAIApiInternal);
    }

    public void enableDebugLogs(long verboseSecret, boolean enable) {
        HashMap<String, Number> verbose = new HashMap<String, Number>();
        verbose.put("Key", verboseSecret);
        verbose.put("LogToFiles", enable ? 1 : 0);
        sJedAIApi.setInternal(verbose);
    }

    @WorkerThread
    public boolean importDatabase(@NonNull Uri fileUri) {
        DocumentFile documentFile;
        if (this.hasStoragePermission(sAppContext) && (documentFile = DocumentFile.fromSingleUri((Context)sAppContext, (Uri)fileUri)) != null && documentFile.exists()) {
            String fileName = documentFile.getName();
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                return false;
            }
            if (documentFile.getName().endsWith(".db")) {
                return this.importJedAIDatabaseFile(documentFile);
            }
            if (documentFile.getName().endsWith(".zip")) {
                return this.importJedAIDatabaseFromZipFile(documentFile);
            }
        }
        return false;
    }

    @Nullable
    public Intent getDebuggingDataImportIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setFlags(1);
        intent.setType("*/*");
        return intent;
    }

    @Nullable
    public Intent getDebuggingDataSendIntent(String userEmail) {
        return this.getDebuggingDataIntent(this.getSendIntent(userEmail));
    }

    @Nullable
    public Intent getDebuggingDataShareIntent() {
        return this.getDebuggingDataIntent(this.getShareIntent());
    }

    @Nullable
    public ZipFile getDebuggingZipDataFile(@Nullable String fileName) {
        try {
            return this.getZipFile(false, fileName);
        }
        catch (ZipException e) {
            sLogger.error((Throwable)e, e.getMessage() != null ? e.getMessage() : "Error, message is [NULL]", new Object[0]);
            return null;
        }
    }

    @NonNull
    public List<DocumentFile> extractFilesFromZipByType(@NonNull Uri zipUri, @NonNull Set<String> fileExtensions, @NonNull File extractPath) {
        return this.mZipProvider.extractFilesFromZip(sAppContext, DocumentFile.fromSingleUri((Context)sAppContext, (Uri)zipUri), fileExtensions, extractPath.getPath());
    }

    public void savePlaybackConfig(@NonNull PlaybackConfig config) {
        sAppContext.getSharedPreferences(APP_PREFERENCES_PLAYBACK, 0).edit().putString(KEY_PLAYBACK_CONFIG, PlaybackUtils.playbackConfigToJson(config).toString()).apply();
    }

    public static void setupPlayback(Context context) {
        sPlaybackConfig = JedAIDebugging.getPlaybackConfig(context);
        JedAIApiWrapperThreadSafe.setPlaybackConfig((PlaybackConfig)sPlaybackConfig);
    }

    public void startPlayback(PlaybackStateListener listener) {
        if (sPlaybackConfig.isPlaybackMode()) {
            JedAIApiWrapperThreadSafe.getInstance().startPlayback(listener);
            JedAIDebugging.clearPlayBackConfig(sAppContext);
        }
    }

    public static boolean isPlaybackMode() {
        return sPlaybackConfig.isPlaybackMode();
    }

    public void setupJemaDebug() {
        String url = SharedPreferencesCommonUtils.INSTANCE.getCurrentManifestUrl(sAppContext);
        if (url != null) {
            JedAIJema.INSTANCE.setSource(url);
        }
    }

    private static void clearPlayBackConfig(Context context) {
        context.getSharedPreferences(APP_PREFERENCES_PLAYBACK, 0).edit().remove(KEY_PLAYBACK_CONFIG).apply();
        sPlaybackConfig = new PlaybackConfig(false);
    }

    private static PlaybackConfig getPlaybackConfig(Context context) {
        return PlaybackUtils.playbackConfigFromJson(context.getSharedPreferences(APP_PREFERENCES_PLAYBACK, 0).getString(KEY_PLAYBACK_CONFIG, ""));
    }

    private boolean importJedAIDatabaseFromZipFile(@NonNull DocumentFile zipFile) {
        String path = sAppContext.getCacheDir() + "/" + TEMP_UNZIP_DIR;
        DocumentFile jedaiDb = this.mZipProvider.extractFileFromZip(sAppContext, zipFile, "jedai.db", path);
        boolean isImported = this.importJedAIDatabaseFile(jedaiDb);
        FileUtils.deleteRecursive((File)new File(path));
        return isImported;
    }

    private boolean importJedAIDatabaseFile(DocumentFile file) {
        if (file == null || !file.exists()) {
            sLogger.error("Failed db import, file not found", new Object[0]);
            return false;
        }
        return DebuggingImportProvider.doImportDB(sAppContext, file, "jedai.db");
    }

    private boolean hasStoragePermission(Context context) {
        try {
            return context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }
        catch (Exception e) {
            sLogger.warning("Has no permission : {0}", new Object[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
            return false;
        }
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    @Nullable
    private Intent getDebuggingDataIntent(@NonNull Intent intent) {
        try {
            ZipFile zipFile = this.getZipFile(true, null);
            this.fillDebuggingDataIntentExtras(intent, zipFile);
            if (Build.VERSION.SDK_INT >= 30) {
                Intent chooser = Intent.createChooser((Intent)intent, (CharSequence)sAppContext.getString(R.string.send_debug_label));
                chooser.addFlags(64);
                return chooser;
            }
            return intent.resolveActivity(sAppContext.getPackageManager()) != null ? Intent.createChooser((Intent)intent, (CharSequence)sAppContext.getString(R.string.send_debug_label)) : null;
        }
        catch (ZipException e) {
            sLogger.error((Throwable)e, e.getMessage(), new Object[0]);
            return null;
        }
    }

    @NonNull
    private ZipFile getZipFile(boolean isEncrypted, @Nullable String fileName) throws ZipException {
        File directory = new File(sAppContext.getFilesDir(), TEMP_DIRECTORY);
        String zipFileName = fileName == null ? "discover_" + System.currentTimeMillis() + ".zip" : fileName;
        return this.mZipProvider.getJedAIDebuggingDataZip(new DebuggingDataZipConfig(directory, zipFileName, false, isEncrypted, true, true, false, false, true, true, true));
    }

    @NonNull
    private Intent getShareIntent() {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("application/octet-stream");
        return intent;
    }

    @NonNull
    private Intent getSendIntent(String userEmail) {
        return new Intent("android.intent.action.SENDTO", Uri.fromParts((String)"mailto", (String)userEmail, null));
    }

    private void fillDebuggingDataIntentExtras(@NonNull Intent intent, @NonNull ZipFile zipFile) {
        String appVersion = sJedAIApi.getVersion();
        String[] emails = new String[]{sAppContext.getString(R.string.send_debug_email_address)};
        String subject = "Discover Debugging Info - " + sAppID + (TextUtils.isEmpty((CharSequence)appVersion) ? "" : appVersion) + " Android feedback";
        String text2 = sAppContext.getString(R.string.send_debug_email_address);
        Uri uri = this.getFileUri(zipFile.getFile());
        intent.setType("message/rfc822");
        intent.addFlags(1);
        intent.putExtra("android.intent.extra.EMAIL", emails);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", text2);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
    }

    private Uri getFileUri(File file) {
        return DebuggingFileProvider.getFileUri(sAppContext, file);
    }

    static {
        sPlaybackConfig = new PlaybackConfig(false);
    }
}

