/*
 * Decompiled with CFR 0.152.
 */
package com.anagog.jedai.debugging.jema_debug.model;

import com.anagog.jedai.common.JedAIEvent;
import com.anagog.jedai.common.activity.ActivityEvent;
import com.anagog.jedai.common.geofence.GeofenceEvent;
import com.anagog.jedai.common.geofence.GeofencePlace;
import com.anagog.jedai.common.geofence.GeofencePoint;
import com.anagog.jedai.common.heartbeat.HeartbeatEvent;
import com.anagog.jedai.common.poi.Poi;
import com.anagog.jedai.common.poi.Point;
import com.anagog.jedai.common.poi.Polygon;
import com.anagog.jedai.common.visit.VisitEvent;
import com.anagog.jedai.debugging.jema_debug.model.SimulateEventCreator;
import com.anagog.jedai.debugging.jema_debug.model.SimulateOptionsState;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/anagog/jedai/debugging/jema_debug/model/SimulateEventCreatorImpl;", "Lcom/anagog/jedai/debugging/jema_debug/model/SimulateEventCreator;", "()V", "create", "Lcom/anagog/jedai/common/JedAIEvent;", "opt", "Lcom/anagog/jedai/debugging/jema_debug/model/SimulateOptionsState$Event;", "generateActivityEvent", "generateGeofanceEvent", "generatePulse", "generateVisitEvent", "polygon", "Lcom/anagog/jedai/common/poi/Polygon$Builder;", "debugging_release"})
public final class SimulateEventCreatorImpl
implements SimulateEventCreator {
    @Override
    @NotNull
    public JedAIEvent create(@NotNull SimulateOptionsState.Event opt) {
        JedAIEvent jedAIEvent;
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        switch (opt.getRuleType()) {
            case "visitEvent": {
                jedAIEvent = this.generateVisitEvent(opt);
                break;
            }
            case "activityEvent": {
                jedAIEvent = this.generateActivityEvent(opt);
                break;
            }
            case "geofenceEvent": {
                jedAIEvent = this.generateGeofanceEvent(opt);
                break;
            }
            default: {
                jedAIEvent = this.generatePulse();
            }
        }
        return jedAIEvent;
    }

    private final JedAIEvent generatePulse() {
        return (JedAIEvent)new HeartbeatEvent(System.currentTimeMillis());
    }

    private final JedAIEvent generateActivityEvent(SimulateOptionsState.Event opt) {
        long l;
        long l2 = System.currentTimeMillis();
        Point point = new Point(4.5, 3.6);
        String string2 = opt.getId();
        switch (string2.hashCode()) {
            case -1591952877: {
                if (string2.equals("enterId")) {
                    l = 16L;
                    break;
                }
            }
            default: {
                l = 32L;
            }
        }
        string2 = opt.getOptType();
        boolean bl = false;
        return (JedAIEvent)new ActivityEvent(1L, l2, point, l, 0, Integer.parseInt(string2));
    }

    private final JedAIEvent generateVisitEvent(SimulateOptionsState.Event opt) {
        long l = System.currentTimeMillis();
        Point point = new Point(4.5, 3.6);
        String string2 = opt.getTriggerId();
        if (string2 == null) {
            string2 = "home";
        }
        String string3 = opt.getOptType();
        String string4 = opt.getOptType();
        String string5 = opt.getOptType();
        String string6 = opt.getTriggerId();
        if (string6 == null) {
            string6 = "home";
        }
        return (JedAIEvent)new VisitEvent(1L, l, point, new Poi("6738512", string2, string3, string4, string5, string6, "", 32.0752757334035, 34.7747232054061, null, 1, "", ""), Intrinsics.areEqual((Object)opt.getId(), (Object)"enterId") ? 1L : 2L);
    }

    private final JedAIEvent generateGeofanceEvent(SimulateOptionsState.Event opt) {
        return (JedAIEvent)new GeofenceEvent(System.currentTimeMillis(), opt.getCampaignId() + '+' + opt.getRuleId() + '+' + opt.getRuleId(), new Point(0.0, 0.0), new GeofencePlace("home", "My+home", new GeofencePoint(new Point(4.5, 3.6), 10.5), this.polygon().build(), "my_home", "", "home"), 0.0, Intrinsics.areEqual((Object)opt.getId(), (Object)"enterId"), 200000L);
    }

    private final Polygon.Builder polygon() {
        Polygon.Builder builder = new Polygon.Builder().addVerticesArray(CollectionsKt.listOf((Object[])new Point[]{new Point(4.5, 3.6), new Point(5.5, 4.6), new Point(6.5, 5.6)}));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Polygon.Builder().addVer\u20265, 4.6),Point(6.5, 5.6)))");
        return builder;
    }
}

