/*
 * Decompiled with CFR 0.152.
 */
package com.anagog.jedai.debugging.zip;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.anagog.jedai.common.stats.Stats;
import com.anagog.jedai.core.api.JedAIApiInternal;
import com.anagog.jedai.core.logger.JedAILogger;
import com.anagog.jedai.debugging.files.FileNameUtils;
import com.anagog.jedai.debugging.files.JedAIFileProvider;
import com.anagog.jedai.debugging.zip.DebuggingDataZipConfig;
import com.anagog.jedai.plugin.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.json.JSONException;
import org.json.JSONObject;

public class DebuggingDataZipProvider {
    private static final JedAILogger sLogger = JedAILogger.getLogger((String)DebuggingDataZipProvider.class.getName());
    private static final String JEDAI_MAIN_DB_NAME = "jedai.db";
    private static final String JEDAI_PERSONAL_POI_DB_NAME = "personal_poi.db";
    private static final String AN_CORE_DB_NAME = "an_core.db";
    private static final String ANAGOG_POI_RESOLVE_CACHE_DB_NAME = "anagog_poi_resolve_cache.db";
    private static final String WEEKDAYS_JSON = "weekdays.json";
    private static final String WEEKEND_JSON = "weekend.json";
    private static final String PROFILE_JSON = "profile.json";
    private static final String EDIT_JSON = "edit.json";
    private static final String ZIP_EXTENSION = "zip";
    private final String mUniqueUserId;
    private final JedAIFileProvider mFileProvider;
    private final JedAIApiInternal mJedApiInternal;

    public DebuggingDataZipProvider(@NonNull JedAIFileProvider fileProvider, @NonNull JedAIApiInternal jedAIApiInternal) {
        this.mFileProvider = fileProvider;
        this.mJedApiInternal = jedAIApiInternal;
        this.mUniqueUserId = this.mJedApiInternal.getReportIDCreator().getUniqueUserId();
    }

    public ZipFile getJedAIDebuggingDataZip(@NonNull DebuggingDataZipConfig config) throws ZipException {
        this.cleanTempDirectory(config.directory);
        File zipTargetFile = new File(config.directory.getPath() + "/" + config.zipFileName);
        ZipFile zipFile = new ZipFile(zipTargetFile);
        String filesSuffix = config.addUserId ? "_" + this.mUniqueUserId : "";
        ZipParameters parameters = this.getZipParameters(config);
        boolean anyDataZipped = false;
        if (config.packLogs) {
            try {
                this.packLogs(zipFile, parameters);
                anyDataZipped = true;
            }
            catch (ZipException e) {
                sLogger.error((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        if (config.packDatabase) {
            try {
                this.packDatabases(JEDAI_MAIN_DB_NAME, zipFile, parameters, filesSuffix);
                anyDataZipped = true;
                this.packDatabases(JEDAI_PERSONAL_POI_DB_NAME, zipFile, parameters, filesSuffix);
                this.packDatabases(AN_CORE_DB_NAME, zipFile, parameters, filesSuffix);
                this.packDatabases(ANAGOG_POI_RESOLVE_CACHE_DB_NAME, zipFile, parameters, filesSuffix);
            }
            catch (ZipException e) {
                sLogger.error((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        if (config.packProfiles) {
            this.packProfiles(zipFile, parameters, filesSuffix);
        }
        if (config.packSchedule) {
            this.packSchedule(zipFile, parameters, filesSuffix);
        }
        if (config.packMicroSegments) {
            anyDataZipped = true;
            File segmentsTargetFile = new File(config.directory.getPath() + "/microsegments.json");
            segmentsTargetFile.delete();
            File segmentsFile = new File(segmentsTargetFile.getAbsolutePath());
            this.packMicroSegments(segmentsFile, zipFile, parameters);
        }
        if (!anyDataZipped) {
            throw new ZipException("Can't zip requested data");
        }
        return zipFile;
    }

    @NonNull
    private ZipParameters getZipParameters(@NonNull DebuggingDataZipConfig config) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setSourceExternalStream(true);
        if (config.encrypt) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(99);
            parameters.setAesKeyStrength(3);
            parameters.setPassword("f33dback");
        }
        return parameters;
    }

    private void cleanTempDirectory(@NonNull File directory) {
        Utils.deleteRecursive((File)directory);
        boolean result_2_1 = directory.mkdirs();
    }

    private void cleanFilteredFiles(@NonNull File rootDir, FilenameFilter filter) {
        for (File file : rootDir.listFiles(filter)) {
            file.delete();
        }
    }

    private void packLogs(@NonNull ZipFile zipFile, @NonNull ZipParameters parameters) throws ZipException {
        for (File file : this.mFileProvider.getLogFiles().listFiles()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.updateFileNameInZip(parameters, file, null);
                zipFile.addStream((InputStream)inputStream, parameters);
            }
            catch (IOException e) {
                throw new ZipException((Throwable)e);
            }
        }
    }

    private void packDatabases(@NonNull String dbName, @NonNull ZipFile zipFile, @NonNull ZipParameters parameters, @Nullable String fileSuffix) throws ZipException {
        for (File file : this.mFileProvider.getDatabaseFiles(dbName)) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.updateFileNameInZip(parameters, file, fileSuffix);
                zipFile.addStream((InputStream)inputStream, parameters);
            }
            catch (IOException e) {
                throw new ZipException((Throwable)e);
            }
        }
    }

    private void packProfiles(@NonNull ZipFile zipFile, @NonNull ZipParameters parameters, @Nullable String fileSuffix) throws ZipException {
        throw new ZipException("Profile packing is not implemented yet");
    }

    private void packSchedule(@NonNull ZipFile zipFile, @NonNull ZipParameters parameters, @Nullable String fileSuffix) throws ZipException {
        throw new ZipException("Schedule packing is not implemented yet");
    }

    private void packMicroSegments(@NonNull File file, @NonNull ZipFile zipFile, @NonNull ZipParameters parameters) throws ZipException {
        ArrayList<String> result = new ArrayList<String>();
        for (Stats.Type type : Stats.Type.values()) {
            Stats stats = this.mJedApiInternal.getStats(type);
            if (stats == null) continue;
            try {
                result.add(this.createStatsJsonObject(stats).toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        Map userDefinedStats = this.mJedApiInternal.getUserDefinedStats();
        if (userDefinedStats != null) {
            for (String userDefined : userDefinedStats.keySet()) {
                Stats stats = this.mJedApiInternal.getStats(userDefined);
                if (stats == null) continue;
                try {
                    result.add(this.createStatsJsonObject(stats).toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(result.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.updateFileNameInZip(parameters, file, null);
            zipFile.addStream((InputStream)inputStream, parameters);
        }
        catch (IOException e) {
            throw new ZipException((Throwable)e);
        }
    }

    private JSONObject createStatsJsonObject(Stats stats) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Name", (Object)stats.getName());
        switch (stats.getMetricType()) {
            case STRING: {
                jsonObject.put("Value", (Object)stats.getStringValue());
                break;
            }
            case DECIMAL: {
                jsonObject.put("Value", (Object)stats.getDecimalValue());
                break;
            }
            case INTEGER: {
                jsonObject.put("Value", (Object)stats.getIntegerValue());
            }
        }
        return jsonObject;
    }

    private void updateFileNameInZip(@NonNull ZipParameters parameters, @NonNull File file, @Nullable String filesSuffix) {
        parameters.setFileNameInZip(TextUtils.isEmpty((CharSequence)filesSuffix) ? file.getName() : FileNameUtils.getFileNameWithoutExtension(file.getName()) + filesSuffix + "." + FileNameUtils.getFileExtension(file.getName()));
    }
}

