/*
 * Decompiled with CFR 0.152.
 */
package com.anagog.jedai.debugging;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.anagog.jedai.common.JedAIApi;
import com.anagog.jedai.core.api.JedAI;
import com.anagog.jedai.core.api.JedAIApiInternal;
import com.anagog.jedai.core.api.JedAIApiWrapperThreadSafe;
import com.anagog.jedai.core.logger.JedAILogger;
import com.anagog.jedai.debugging.DebuggingFileProvider;
import com.anagog.jedai.debugging.R;
import com.anagog.jedai.debugging.files.JedAIFileProvider;
import com.anagog.jedai.debugging.zip.DebuggingDataZipConfig;
import com.anagog.jedai.debugging.zip.DebuggingDataZipProvider;
import java.io.File;
import java.util.HashMap;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;

public class JedAIDebugging {
    private static final JedAILogger sLogger = JedAILogger.getLogger((String)JedAIDebugging.class.getName());
    private static final String TEMP_DIRECTORY = "debugging_tmp";
    private static Context sAppContext;
    private static String sAppID;
    private static JedAIApi sJedAIApi;
    private static JedAIDebugging sInstance;
    private DebuggingDataZipProvider mZipProvider;

    public static JedAIDebugging getInstance() {
        if (sInstance == null) {
            sInstance = new JedAIDebugging();
        }
        return sInstance;
    }

    public static void setup(@NonNull Context context) {
        JedAI jedAIApi = JedAI.getInstance();
        if (jedAIApi == null) {
            throw new IllegalStateException("You must initialize JedAI before instance claiming");
        }
        JedAIDebugging.setup(context, (JedAIApi)jedAIApi);
    }

    public static void setup(@NonNull Context context, @NonNull JedAIApi jedAIApi) {
        sAppContext = context.getApplicationContext();
        sAppID = sAppContext.getPackageName();
        sJedAIApi = jedAIApi;
    }

    private JedAIDebugging() {
        JedAIFileProvider fileProvider = new JedAIFileProvider(sAppID);
        JedAIApiWrapperThreadSafe jedAIApiInternal = JedAIApiWrapperThreadSafe.getInstance();
        this.mZipProvider = new DebuggingDataZipProvider(fileProvider, (JedAIApiInternal)jedAIApiInternal);
    }

    public void enableDebugLogs(long verboseSecret, boolean enable) {
        HashMap<String, Number> verbose = new HashMap<String, Number>();
        verbose.put("Key", verboseSecret);
        verbose.put("LogToFiles", enable ? 1 : 0);
        sJedAIApi.setInternal(verbose);
    }

    @Nullable
    public Intent getDebuggingDataSendIntent(String userEmail) {
        return this.getDebuggingDataIntent(this.getSendIntent(userEmail));
    }

    @Nullable
    public Intent getDebuggingDataShareIntent() {
        return this.getDebuggingDataIntent(this.getShareIntent());
    }

    @Nullable
    private Intent getDebuggingDataIntent(@NonNull Intent intent) {
        try {
            ZipFile zipFile = this.getZipFile();
            this.fillDebuggingDataIntentExtras(intent, zipFile);
            return intent.resolveActivity(sAppContext.getPackageManager()) != null ? Intent.createChooser((Intent)intent, (CharSequence)sAppContext.getString(R.string.send_debug_label)) : null;
        }
        catch (ZipException e) {
            sLogger.error((Throwable)e, e.getMessage(), new Object[0]);
            return null;
        }
    }

    @NonNull
    private ZipFile getZipFile() throws ZipException {
        File directory = new File(sAppContext.getFilesDir(), TEMP_DIRECTORY);
        String zipFileName = "discover_" + System.currentTimeMillis() + ".zip";
        return this.mZipProvider.getJedAIDebuggingDataZip(new DebuggingDataZipConfig(directory, zipFileName, false, true, true, true, false, false, true));
    }

    @NonNull
    private Intent getShareIntent() {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("application/octet-stream");
        return intent;
    }

    @NonNull
    private Intent getSendIntent(String userEmail) {
        return new Intent("android.intent.action.SENDTO", Uri.fromParts((String)"mailto", (String)userEmail, null));
    }

    private void fillDebuggingDataIntentExtras(@NonNull Intent intent, @NonNull ZipFile zipFile) {
        String appVersion = sJedAIApi.getVersion();
        String[] emails = new String[]{sAppContext.getString(R.string.send_debug_email_address)};
        String subject = "Discover Debugging Info - " + sAppID + (TextUtils.isEmpty((CharSequence)appVersion) ? "" : appVersion) + " Android feedback";
        String text = sAppContext.getString(R.string.send_debug_email_address);
        Uri uri = this.getFileUri(zipFile.getFile());
        intent.setType("message/rfc822");
        intent.addFlags(1);
        intent.putExtra("android.intent.extra.EMAIL", emails);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", text);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
    }

    private Uri getFileUri(File file) {
        return DebuggingFileProvider.getFileUri(sAppContext, file);
    }
}

