/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.Event;
import com.amplitude.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class AmplitudeLog {
    private LogMode logMode = LogMode.ERROR;
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void setLogMode(LogMode logMode) {
        this.logMode = logMode;
    }

    public void debug(String tag, String message) {
        this.log(tag, message, LogMode.DEBUG);
    }

    public void warn(String tag, String message) {
        this.log(tag, message, LogMode.WARN);
    }

    public void error(String tag, String message) {
        this.log(tag, message, LogMode.ERROR);
    }

    public void debug(String tag, List<Event> events, Response response) {
        if (this.logMode == LogMode.DEBUG) {
            String debugMessage = sdfDate.format(new Date()) + " " + tag + ": ";
            debugMessage = debugMessage + "Events count " + events.size() + ".\n" + response.toString();
            System.out.println(debugMessage);
        }
    }

    public void log(String tag, String message, LogMode messageMode) {
        if (messageMode.level >= this.logMode.level) {
            if (messageMode.level >= LogMode.ERROR.level) {
                System.err.println(tag + ": " + message);
            } else {
                System.out.println(tag + ": " + message);
            }
        }
    }

    public static enum LogMode {
        DEBUG(1),
        WARN(2),
        ERROR(3),
        OFF(4);

        private int level;

        private LogMode(int level) {
            this.level = level;
        }
    }
}

