/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.AmplitudeCallbacks;
import com.amplitude.AmplitudeLog;
import com.amplitude.Constants;
import com.amplitude.Event;
import com.amplitude.EventsRetryResult;
import com.amplitude.HttpCall;
import com.amplitude.Response;
import com.amplitude.Status;
import com.amplitude.exception.AmplitudeInvalidAPIKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

class HttpTransport {
    private Map<String, Map<String, Queue<Event>>> idToBuffer = new ConcurrentHashMap<String, Map<String, Queue<Event>>>();
    private AtomicInteger eventsInRetry = new AtomicInteger(0);
    private HttpCall httpCall;
    private AmplitudeLog logger;
    private AmplitudeCallbacks callbacks;

    HttpTransport(HttpCall httpCall, AmplitudeCallbacks callbacks, AmplitudeLog logger) {
        this.httpCall = httpCall;
        this.callbacks = callbacks;
        this.logger = logger;
    }

    public void sendEventsWithRetry(List<Event> events) {
        ((CompletableFuture)this.sendEvents(events).thenAcceptAsync(response -> {
            Status status = response.status;
            if (this.shouldRetryForStatus(status)) {
                this.retryEvents(events, (Response)response);
            } else if (status == Status.SUCCESS) {
                this.triggerEventCallbacks(events, response.code, "Event sent success.");
            } else if (status == Status.FAILED) {
                this.triggerEventCallbacks(events, response.code, "Event sent Failed.");
            } else {
                this.triggerEventCallbacks(events, response.code, "Unknown response status.");
            }
        })).exceptionally(exception -> {
            this.logger.error("Invalid API Key", exception.getMessage());
            return null;
        });
    }

    public void retryEvents(List<Event> events, Response response) {
        List<Event> eventsToSend = this.pruneEvent(events);
        if (this.eventsInRetry.intValue() < 16000) {
            this.onEventsError(eventsToSend, response);
        }
    }

    public void setHttpCall(HttpCall httpCall) {
        this.httpCall = httpCall;
    }

    public void setCallbacks(AmplitudeCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    private CompletableFuture<Response> sendEvents(List<Event> events) {
        return CompletableFuture.supplyAsync(() -> {
            Response response = null;
            try {
                response = this.httpCall.makeRequest(events);
                this.logger.debug("SEND", events, response);
            }
            catch (AmplitudeInvalidAPIKeyException e) {
                throw new CompletionException(e);
            }
            return response;
        });
    }

    private void onEventsError(List<Event> events, Response response) {
        List<Event> eventsToRetry = this.getEventListToRetry(events, response);
        if (eventsToRetry.isEmpty()) {
            return;
        }
        HashMap<String, Set> userToDevices = new HashMap<String, Set>();
        for (Event event : eventsToRetry) {
            String deviceId;
            String userId2 = event.userId != null ? event.userId : "";
            String string = deviceId = event.deviceId != null ? event.deviceId : "";
            if (userId2.length() <= 0 && deviceId.length() <= 0) continue;
            this.addEventToBuffer(userId2, deviceId, event);
            userToDevices.computeIfAbsent(userId2, key -> new HashSet()).add(deviceId);
        }
        userToDevices.forEach((userId, deviceSet) -> deviceSet.forEach(deviceId -> this.retryEventsOnLoop((String)userId, (String)deviceId)));
    }

    private void retryEventsOnLoop(String userId, String deviceId) {
        Thread retryThread = new Thread(() -> {
            Queue<Event> eventsQueue = this.getEventsFromBuffer(userId, deviceId);
            if (eventsQueue == null || eventsQueue.size() == 0) {
                this.cleanUpBuffer(userId);
                return;
            }
            ArrayList<Event> eventsBuffer = new ArrayList<Event>(eventsQueue);
            int retryTimes = Constants.RETRY_TIMEOUTS.length;
            int eventCount = eventsBuffer.size();
            for (int numRetries = 0; numRetries < retryTimes; ++numRetries) {
                long sleepDuration = Constants.RETRY_TIMEOUTS[numRetries];
                try {
                    Thread.sleep(sleepDuration);
                    boolean isLastTry = numRetries == Constants.RETRY_TIMEOUTS.length - 1;
                    List<Event> eventsToRetry = eventsBuffer.subList(0, eventCount);
                    EventsRetryResult retryResult = this.retryEventsOnce(userId, deviceId, eventsToRetry);
                    boolean shouldRetry = retryResult.shouldRetry;
                    boolean shouldReduceEventCount = retryResult.shouldReduceEventCount;
                    int[] eventIndicesToRemove = retryResult.eventIndicesToRemove;
                    if (eventIndicesToRemove.length > 0) {
                        ArrayList<Event> eventsToDrop = new ArrayList<Event>();
                        int numEventsRemoved = 0;
                        for (int i = eventIndicesToRemove.length - 1; i >= 0; --i) {
                            int index = eventIndicesToRemove[i];
                            if (index >= eventCount) continue;
                            eventsToDrop.add((Event)eventsBuffer.remove(index));
                            ++numEventsRemoved;
                        }
                        this.triggerEventCallbacks(eventsToDrop, retryResult.statusCode, "Invalid events.");
                        eventCount -= numEventsRemoved;
                        this.eventsInRetry.addAndGet(-numEventsRemoved);
                    }
                    if (!shouldRetry || eventCount < 1) break;
                    if (shouldReduceEventCount && !isLastTry) {
                        this.triggerEventCallbacks(eventsBuffer.subList(eventCount / 2, eventCount), retryResult.statusCode, "Event dropped for retry");
                        eventCount /= 2;
                    }
                    if (isLastTry) {
                        this.triggerEventCallbacks(eventsBuffer.subList(0, eventCount), retryResult.statusCode, "Event retries exhausted.");
                    }
                    if (eventCount != 0) continue;
                    break;
                }
                catch (AmplitudeInvalidAPIKeyException | InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.eventsInRetry.addAndGet(-eventCount);
        });
        retryThread.start();
    }

    private EventsRetryResult retryEventsOnce(String userId, String deviceId, List<Event> events) throws AmplitudeInvalidAPIKeyException {
        Response response = this.httpCall.makeRequest(events);
        this.logger.debug("RETRY", events, response);
        boolean shouldRetry = true;
        boolean shouldReduceEventCount = false;
        int[] eventIndicesToRemove = new int[]{};
        switch (response.status) {
            case SUCCESS: {
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, "Events sent success.");
                break;
            }
            case RATELIMIT: {
                if (response.isUserOrDeviceExceedQuote(userId, deviceId)) {
                    shouldRetry = false;
                    this.triggerEventCallbacks(events, response.code, response.error);
                }
                shouldReduceEventCount = true;
                break;
            }
            case PAYLOAD_TOO_LARGE: {
                shouldRetry = true;
                break;
            }
            case INVALID: {
                if (events.size() == 1) {
                    shouldRetry = false;
                    this.triggerEventCallbacks(events, response.code, response.error);
                    break;
                }
                eventIndicesToRemove = response.collectInvalidEventIndices();
                break;
            }
        }
        return new EventsRetryResult(shouldRetry, shouldReduceEventCount, eventIndicesToRemove, response.code, response.error);
    }

    private List<Event> getEventListToRetry(List<Event> events, Response response) {
        List<Event> eventsToRetry = events;
        ArrayList<Event> eventsToDrop = new ArrayList<Event>();
        if (response.status == Status.SUCCESS) {
            return new ArrayList<Event>();
        }
        if (response.status == Status.INVALID) {
            if (response.invalidRequestBody != null && response.invalidRequestBody.has("missingField") && response.invalidRequestBody.getString("missingField").length() > 0 || events.size() == 1) {
                this.triggerEventCallbacks(events, response.code, response.error);
                return new ArrayList<Event>();
            }
            if (response.invalidRequestBody != null) {
                int[] invalidEventIndices = response.collectInvalidEventIndices();
                eventsToRetry = new ArrayList<Event>();
                for (int i = 0; i < events.size(); ++i) {
                    if (Arrays.binarySearch(invalidEventIndices, i) < 0) {
                        eventsToRetry.add(events.get(i));
                        continue;
                    }
                    eventsToDrop.add(events.get(i));
                }
                this.triggerEventCallbacks(eventsToDrop, response.code, response.error);
            }
        } else if (response.status == Status.RATELIMIT && response.rateLimitBody != null) {
            eventsToRetry = new ArrayList<Event>();
            for (Event event : events) {
                if (!response.isUserOrDeviceExceedQuote(event.userId, event.deviceId)) {
                    eventsToRetry.add(event);
                    continue;
                }
                eventsToDrop.add(event);
            }
            this.triggerEventCallbacks(eventsToDrop, response.code, "User or Device Exceed Daily Quota.");
        }
        return eventsToRetry;
    }

    private List<Event> pruneEvent(List<Event> events) {
        ArrayList<Event> prunedEvents = new ArrayList<Event>();
        for (Event event : events) {
            String userId = event.userId;
            String deviceId = event.deviceId;
            if ((userId == null || userId.length() <= 0) && (deviceId == null || deviceId.length() <= 0)) continue;
            this.idToBuffer.compute(userId, (key, value) -> {
                if (value == null) {
                    prunedEvents.add(event);
                    return null;
                }
                value.compute(deviceId, (deviceKey, deviceValue) -> {
                    if (deviceValue == null) {
                        prunedEvents.add(event);
                        return null;
                    }
                    deviceValue.add(event);
                    this.eventsInRetry.incrementAndGet();
                    return deviceValue;
                });
                return value;
            });
        }
        return prunedEvents;
    }

    private void cleanUpBuffer(String userId) {
        this.idToBuffer.computeIfPresent(userId, (key, value) -> value == null || value.isEmpty() ? null : value);
    }

    protected boolean shouldRetryForStatus(Status status) {
        return status == Status.INVALID || status == Status.PAYLOAD_TOO_LARGE || status == Status.RATELIMIT || status == Status.TIMEOUT;
    }

    private void triggerEventCallbacks(List<Event> events, int status, String message) {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (Event event : events) {
            if (this.callbacks != null) {
                this.callbacks.onLogEventServerResponse(event, status, message);
            }
            if (event.callback == null) continue;
            event.callback.onLogEventServerResponse(event, status, message);
        }
    }

    private void addEventToBuffer(String userId, String deviceId, Event event) {
        this.idToBuffer.compute(userId, (key, value) -> {
            if (value == null) {
                value = new ConcurrentHashMap<String, Queue>();
            }
            value.compute(deviceId, (deviceKey, deviceValue) -> {
                if (deviceValue == null) {
                    deviceValue = new ConcurrentLinkedQueue<Event>();
                }
                deviceValue.add(event);
                return deviceValue;
            });
            return value;
        });
    }

    private Queue<Event> getEventsFromBuffer(String userId, String deviceId) {
        ArrayList eventQueues = new ArrayList();
        this.idToBuffer.compute(userId, (key, value) -> {
            if (value == null) {
                return null;
            }
            value.compute(deviceId, (deviceKey, deviceValue) -> {
                if (deviceValue != null) {
                    eventQueues.add(deviceValue);
                }
                return null;
            });
            return value;
        });
        return eventQueues.isEmpty() ? null : (Queue)eventQueues.get(0);
    }
}

