/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.Event;
import com.amplitude.Options;
import com.amplitude.Response;
import com.amplitude.Status;
import com.amplitude.exception.AmplitudeInvalidAPIKeyException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpCall {
    private final String apiKey;
    private final String serverUrl;
    private final Options options;

    protected HttpCall(String apiKey, String serverUrl) {
        this(apiKey, serverUrl, null);
    }

    protected HttpCall(String apiKey, String serverUrl, Options options) {
        this.apiKey = apiKey;
        this.serverUrl = serverUrl;
        this.options = options;
    }

    protected String getApiUrl() {
        return this.serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response makeRequest(List<Event> events) throws AmplitudeInvalidAPIKeyException {
        String apiUrl = this.getApiUrl();
        InputStream inputStream = null;
        int responseCode = 500;
        Response responseBody = new Response();
        try {
            String output;
            HttpsURLConnection connection = (HttpsURLConnection)new URL(apiUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            JSONObject bodyJson = new JSONObject();
            bodyJson.put("api_key", (Object)this.apiKey);
            if (this.options != null) {
                bodyJson.put("options", (Object)this.options.toJsonObject());
            }
            JSONArray eventsArr = new JSONArray();
            for (int i = 0; i < events.size(); ++i) {
                eventsArr.put(i, (Object)events.get(i).toJsonObject());
            }
            bodyJson.put("events", (Object)eventsArr);
            String bodyString = bodyJson.toString();
            OutputStream os = connection.getOutputStream();
            byte[] input = bodyString.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
            responseCode = connection.getResponseCode();
            boolean isErrorCode = responseCode >= 400;
            inputStream = !isErrorCode ? connection.getInputStream() : connection.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            JSONObject responseJson = new JSONObject(sb.toString());
            responseBody = Response.populateResponse(responseJson);
        }
        catch (IOException e) {
            JSONObject timesOutResponse = new JSONObject();
            timesOutResponse.put("status", (Object)Status.TIMEOUT);
            timesOutResponse.put("code", 408);
            responseBody = Response.populateResponse(timesOutResponse);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return responseBody;
    }
}

