/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.AmplitudeCallbacks;
import com.amplitude.AmplitudeLog;
import com.amplitude.Event;
import com.amplitude.HttpCall;
import com.amplitude.HttpCallMode;
import com.amplitude.HttpTransport;
import com.amplitude.Middleware;
import com.amplitude.MiddlewareExtra;
import com.amplitude.MiddlewarePayload;
import com.amplitude.MiddlewareRunner;
import com.amplitude.Options;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Amplitude {
    private static Map<String, Amplitude> instances = new HashMap<String, Amplitude>();
    private String apiKey;
    private String serverUrl;
    private AmplitudeLog logger;
    private Queue<Event> eventsToSend;
    private boolean aboutToStartFlushing = false;
    private HttpCallMode httpCallMode;
    private HttpCall httpCall;
    private HttpTransport httpTransport;
    private int eventUploadThreshold = 10;
    private int eventUploadPeriodMillis = 10000;
    private Options options;
    MiddlewareRunner middlewareRunner = new MiddlewareRunner();

    private Amplitude() {
        this.logger = new AmplitudeLog();
        this.eventsToSend = new ConcurrentLinkedQueue<Event>();
        this.httpTransport = new HttpTransport(this.httpCall, null, this.logger);
    }

    public static Amplitude getInstance() {
        return Amplitude.getInstance("");
    }

    public static Amplitude getInstance(String instanceName) {
        if (!instances.containsKey(instanceName)) {
            Amplitude ampInstance = new Amplitude();
            instances.put(instanceName, ampInstance);
        }
        return instances.get(instanceName);
    }

    public void init(String key) {
        this.apiKey = key;
        this.updateHttpCall(HttpCallMode.REGULAR);
    }

    public void setServerUrl(String url) {
        boolean isValidServerUrl;
        boolean bl = isValidServerUrl = url.startsWith("http://") || url.startsWith("https://");
        if (!isValidServerUrl) {
            return;
        }
        this.serverUrl = url;
        this.updateHttpCall(this.httpCallMode);
    }

    public void setOptions(Options options) {
        this.options = options;
        this.updateHttpCall(this.httpCallMode);
    }

    public void useBatchMode(Boolean isBatchMode) {
        this.updateHttpCall(isBatchMode != false ? HttpCallMode.BATCH : HttpCallMode.REGULAR);
    }

    public void setLogMode(AmplitudeLog.LogMode logMode) {
        this.logger.setLogMode(logMode);
    }

    public Amplitude setEventUploadThreshold(int eventUploadThreshold) {
        this.eventUploadThreshold = eventUploadThreshold;
        return this;
    }

    public Amplitude setEventUploadPeriodMillis(int eventUploadPeriodMillis) {
        this.eventUploadPeriodMillis = eventUploadPeriodMillis;
        return this;
    }

    public void setCallbacks(AmplitudeCallbacks callbacks) {
        this.httpTransport.setCallbacks(callbacks);
    }

    public synchronized void addEventMiddleware(Middleware middleware) {
        this.middlewareRunner.add(middleware);
    }

    public synchronized void logEvent(Event event) {
        this.logEvent(event, null, null);
    }

    public synchronized void logEvent(Event event, MiddlewareExtra extra) {
        this.logEvent(event, null, extra);
    }

    public synchronized void logEvent(Event event, AmplitudeCallbacks callbacks) {
        this.logEvent(event, callbacks, null);
    }

    public synchronized void logEvent(Event event, AmplitudeCallbacks callbacks, MiddlewareExtra extra) {
        if (!this.middlewareRunner.run(new MiddlewarePayload(event, extra))) {
            return;
        }
        if (callbacks != null) {
            event.callback = callbacks;
        }
        this.eventsToSend.add(event);
        if (this.eventsToSend.size() >= this.eventUploadThreshold) {
            this.flushEvents();
        } else {
            this.scheduleFlushEvents();
        }
    }

    public synchronized void flushEvents() {
        if (this.eventsToSend.size() > 0) {
            ArrayList<Event> eventsInTransit = new ArrayList<Event>(this.eventsToSend);
            this.eventsToSend.clear();
            this.httpTransport.sendEventsWithRetry(eventsInTransit);
        }
    }

    private void updateHttpCall(HttpCallMode updatedHttpCallMode) {
        this.httpCallMode = updatedHttpCallMode;
        this.httpCall = updatedHttpCallMode == HttpCallMode.BATCH ? new HttpCall(this.apiKey, this.serverUrl != null ? this.serverUrl : "https://api2.amplitude.com/batch", this.options) : new HttpCall(this.apiKey, this.serverUrl != null ? this.serverUrl : "https://api2.amplitude.com/2/httpapi", this.options);
        this.httpTransport.setHttpCall(this.httpCall);
    }

    private void scheduleFlushEvents() {
        if (!this.aboutToStartFlushing) {
            this.aboutToStartFlushing = true;
            Thread flushThread = new Thread(() -> {
                try {
                    Thread.sleep(this.eventUploadPeriodMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.flushEvents();
                this.aboutToStartFlushing = false;
            });
            flushThread.start();
        }
    }
}

