/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.AmplitudeCallbacks;
import com.amplitude.AmplitudeLog;
import com.amplitude.Constants;
import com.amplitude.Event;
import com.amplitude.EventsRetryResult;
import com.amplitude.HttpCall;
import com.amplitude.Response;
import com.amplitude.Status;
import com.amplitude.Utils;
import com.amplitude.exception.AmplitudeInvalidAPIKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class HttpTransport {
    private Object throttleLock = new Object();
    private Map<String, Integer> throttledUserId = new HashMap<String, Integer>();
    private Map<String, Integer> throttledDeviceId = new HashMap<String, Integer>();
    private boolean recordThrottledId = false;
    private Map<String, Map<String, List<Event>>> idToBuffer = new HashMap<String, Map<String, List<Event>>>();
    private int eventsInRetry = 0;
    private Object bufferLock = new Object();
    private Object counterLock = new Object();
    private HttpCall httpCall;
    private AmplitudeLog logger;
    private AmplitudeCallbacks callbacks;
    private long flushTimeout;
    private ExecutorService retryThreadPool = Executors.newFixedThreadPool(10);
    private ExecutorService sendThreadPool = Executors.newFixedThreadPool(20);
    private ExecutorService supplyAsyncPool = Executors.newCachedThreadPool();

    HttpTransport(HttpCall httpCall, AmplitudeCallbacks callbacks, AmplitudeLog logger, long flushTimeout) {
        this.httpCall = httpCall;
        this.callbacks = callbacks;
        this.logger = logger;
        this.flushTimeout = flushTimeout;
    }

    public void sendEventsWithRetry(List<Event> events) {
        CompletableFuture.runAsync(new SendEventsTask(events), this.sendThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        this.sendThreadPool.shutdown();
        this.retryThreadPool.shutdown();
        Object object = this.bufferLock;
        synchronized (object) {
            for (String userId : this.idToBuffer.keySet()) {
                for (String deviceId : this.idToBuffer.get(userId).keySet()) {
                    this.triggerEventCallbacks(this.idToBuffer.get(userId).remove(deviceId), 0, "Client shutdown. Events not retry.");
                }
                this.idToBuffer.remove(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryEvents(List<Event> events, Response response) {
        int bufferSize;
        Object object = this.counterLock;
        synchronized (object) {
            bufferSize = this.eventsInRetry;
        }
        if (bufferSize < 16000) {
            this.onEventsError(events, response);
        } else {
            String message = "Retry buffer is full(" + bufferSize + "), " + events.size() + " events dropped.";
            this.logger.warn("DROP EVENTS", message);
            this.triggerEventCallbacks(events, response.code, message);
        }
    }

    public void setHttpCall(HttpCall httpCall) {
        this.httpCall = httpCall;
    }

    public void setFlushTimeout(long timeout) {
        this.flushTimeout = timeout;
    }

    public void setSendThreadPool(ExecutorService sendThreadPool) {
        this.sendThreadPool = sendThreadPool;
    }

    public void setRetryThreadPool(ExecutorService retryThreadPool) {
        this.retryThreadPool = retryThreadPool;
    }

    public void setCallbacks(AmplitudeCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public void setLogger(AmplitudeLog logger) {
        this.logger = logger;
    }

    private CompletableFuture<Response> sendEvents(List<Event> events) {
        return CompletableFuture.supplyAsync(() -> {
            Response response = null;
            try {
                response = this.httpCall.makeRequest(events);
                this.logger.debug("SEND", "Events count " + events.size());
                this.logger.debug("RESPONSE", response.toString());
            }
            catch (AmplitudeInvalidAPIKeyException e) {
                throw new CompletionException(e);
            }
            return response;
        }, this.supplyAsyncPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEventsError(List<Event> events, Response response) {
        HashSet<String> users;
        List<Event> eventsToRetry = this.getEventListToRetry(events, response);
        if (eventsToRetry.isEmpty()) {
            return;
        }
        for (Event event : eventsToRetry) {
            String deviceId;
            String userId = event.userId != null ? event.userId : "";
            String string = deviceId = event.deviceId != null ? event.deviceId : "";
            if (userId.length() <= 0 && deviceId.length() <= 0) continue;
            this.addEventToBuffer(userId, deviceId, event);
        }
        Iterator iterator = this.bufferLock;
        synchronized (iterator) {
            users = new HashSet<String>(this.idToBuffer.keySet());
        }
        for (String userId : users) {
            HashSet<String> devices = null;
            Iterator iterator2 = this.bufferLock;
            synchronized (iterator2) {
                Map<String, List<Event>> deviceMap = this.idToBuffer.get(userId);
                if (deviceMap != null) {
                    devices = new HashSet<String>(deviceMap.keySet());
                }
            }
            if (devices == null) continue;
            for (String deviceId : devices) {
                RetryEventsOnLoop task = new RetryEventsOnLoop(userId, deviceId);
                try {
                    this.retryThreadPool.execute(task);
                }
                catch (RejectedExecutionException e) {
                    this.logger.error("Failed init retry thread", Utils.getStackTrace(e));
                    this.triggerEventCallbacks(task.events, 0, "Failed init retry thread");
                }
            }
        }
    }

    private EventsRetryResult retryEventsOnce(String userId, String deviceId, List<Event> events) throws AmplitudeInvalidAPIKeyException {
        Response response = this.httpCall.makeRequest(events);
        this.logger.debug("RETRY", "Events count " + events.size());
        this.logger.debug("RESPONSE", response.toString());
        boolean shouldRetry = true;
        boolean shouldReduceEventCount = false;
        int[] eventIndicesToRemove = new int[]{};
        switch (response.status) {
            case SUCCESS: {
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, "Events sent success.");
                break;
            }
            case RATELIMIT: {
                if (!response.isUserOrDeviceExceedQuote(userId, deviceId)) break;
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, response.error);
                break;
            }
            case PAYLOAD_TOO_LARGE: {
                shouldRetry = true;
                shouldReduceEventCount = true;
                break;
            }
            case INVALID: {
                if (events.size() == 1) {
                    shouldRetry = false;
                    this.triggerEventCallbacks(events, response.code, response.error);
                    break;
                }
                eventIndicesToRemove = response.collectInvalidEventIndices();
                break;
            }
            case UNKNOWN: {
                shouldRetry = false;
                this.triggerEventCallbacks(events, response.code, "Unknown response status.");
                break;
            }
            case FAILED: {
                shouldRetry = true;
                break;
            }
        }
        return new EventsRetryResult(shouldRetry, shouldReduceEventCount, eventIndicesToRemove, response.code, response.error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getEventListToRetry(List<Event> events, Response response) {
        ArrayList<Event> eventsToRetry = new ArrayList();
        List<Event> eventsToDrop = new ArrayList<Event>();
        if (response.status == Status.INVALID && response.invalidRequestBody != null) {
            if (response.invalidRequestBody.has("missingField") && response.invalidRequestBody.getString("missingField").length() > 0 || events.size() == 1) {
                eventsToDrop = events;
            } else {
                int[] invalidEventIndices = response.collectInvalidEventIndices();
                for (int i = 0; i < events.size(); ++i) {
                    if (Arrays.binarySearch(invalidEventIndices, i) < 0) {
                        eventsToRetry.add(events.get(i));
                        continue;
                    }
                    eventsToDrop.add(events.get(i));
                }
            }
        } else if (response.status == Status.RATELIMIT && response.rateLimitBody != null) {
            for (Event event : events) {
                if (!response.isUserOrDeviceExceedQuote(event.userId, event.deviceId)) {
                    eventsToRetry.add(event);
                    if (!this.recordThrottledId) continue;
                    try {
                        JSONObject throttledUser = response.rateLimitBody.getJSONObject("throttledUsers");
                        JSONObject throttledDevice = response.rateLimitBody.getJSONObject("throttledDevices");
                        Object object = this.throttleLock;
                        synchronized (object) {
                            if (throttledUser.has(event.userId)) {
                                this.throttledUserId.put(event.userId, throttledUser.getInt(event.userId));
                            }
                            if (throttledDevice.has(event.deviceId)) {
                                this.throttledDeviceId.put(event.deviceId, throttledDevice.getInt(event.deviceId));
                            }
                            continue;
                        }
                    }
                    catch (JSONException e) {
                        this.logger.debug("THROTTLED", "Error get throttled userId or deviceId");
                        continue;
                    }
                }
                eventsToDrop.add(event);
            }
        } else {
            eventsToRetry = events;
        }
        this.triggerEventCallbacks(eventsToDrop, response.code, response.error);
        return eventsToRetry;
    }

    protected boolean shouldRetryForStatus(Status status) {
        return status == Status.INVALID || status == Status.PAYLOAD_TOO_LARGE || status == Status.RATELIMIT || status == Status.TIMEOUT || status == Status.FAILED;
    }

    private void triggerEventCallbacks(List<Event> events, int status, String message) {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (Event event : events) {
            if (this.callbacks != null) {
                this.callbacks.onLogEventServerResponse(event, status, message);
            }
            if (event.callback == null) continue;
            event.callback.onLogEventServerResponse(event, status, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventToBuffer(String userId, String deviceId, Event event) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (!this.idToBuffer.containsKey(userId)) {
                this.idToBuffer.put(userId, new HashMap());
            }
            if (!this.idToBuffer.get(userId).containsKey(deviceId)) {
                this.idToBuffer.get(userId).put(deviceId, new ArrayList());
            }
            this.idToBuffer.get(userId).get(deviceId).add(event);
        }
        object = this.counterLock;
        synchronized (object) {
            ++this.eventsInRetry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getEventsFromBuffer(String userId, String deviceId) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.idToBuffer.containsKey(userId) && this.idToBuffer.get(userId).containsKey(deviceId)) {
                List<Event> events = this.idToBuffer.get(userId).remove(deviceId);
                if (this.idToBuffer.get(userId).isEmpty()) {
                    this.idToBuffer.remove(userId);
                }
                return events;
            }
        }
        return null;
    }

    public boolean shouldWait(Event event) {
        if (this.recordThrottledId && (this.throttledUserId.containsKey(event.userId) || this.throttledDeviceId.containsKey(event.deviceId))) {
            return true;
        }
        return this.eventsInRetry >= 16000;
    }

    public void setRecordThrottledId(boolean record) {
        this.recordThrottledId = record;
    }

    class SendEventsTask
    implements Runnable {
        private List<Event> events;

        SendEventsTask(List<Event> events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int statusCode = 0;
            String callbackMessage = "Error send events";
            boolean needCallback = true;
            try {
                CompletableFuture future = HttpTransport.this.sendEvents(this.events);
                Response response = HttpTransport.this.flushTimeout > 0L ? (Response)future.get(HttpTransport.this.flushTimeout, TimeUnit.MILLISECONDS) : (Response)future.get();
                if (response == null) {
                    HttpTransport.this.logger.debug("Unexpected null response", "Retry events.");
                    needCallback = false;
                    HttpTransport.this.retryEvents(this.events, new Response());
                }
                Status status = response.status;
                statusCode = response.code;
                if (HttpTransport.this.shouldRetryForStatus(status)) {
                    needCallback = false;
                    HttpTransport.this.retryEvents(this.events, response);
                } else {
                    callbackMessage = status == Status.SUCCESS ? "Event sent success." : (status == Status.FAILED ? "Event sent Failed." : "Unknown response status.");
                }
            }
            catch (Exception exception) {
                callbackMessage = "Error sending events due to the exception: " + exception + ". Message: " + exception.getMessage();
                HttpTransport.this.logger.error("Flush Thread Error", Utils.getStackTrace(exception));
                HttpTransport.this.logger.error("Error event payload", this.events.toString());
            }
            finally {
                if (needCallback) {
                    HttpTransport.this.triggerEventCallbacks(this.events, statusCode, callbackMessage);
                }
            }
        }
    }

    class RetryEventsOnLoop
    implements Runnable {
        private String userId;
        private String deviceId;
        private List<Event> events;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RetryEventsOnLoop(String userId, String deviceId) {
            this.deviceId = deviceId;
            this.userId = userId;
            this.events = HttpTransport.this.getEventsFromBuffer(userId, deviceId);
            if (this.events != null) {
                Object object = HttpTransport.this.counterLock;
                synchronized (object) {
                    HttpTransport.this.eventsInRetry = HttpTransport.this.eventsInRetry - this.events.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int eventCount;
            if (this.events == null || this.events.size() == 0) {
                return;
            }
            int retryTimes = Constants.RETRY_TIMEOUTS.length;
            for (int numRetries = 0; numRetries < retryTimes && (eventCount = this.events.size()) > 0; ++numRetries) {
                long sleepDuration = Constants.RETRY_TIMEOUTS[numRetries];
                try {
                    List<Object> eventsToDrop;
                    Thread.sleep(sleepDuration);
                    boolean isLastTry = numRetries == retryTimes - 1;
                    EventsRetryResult retryResult = HttpTransport.this.retryEventsOnce(this.userId, this.deviceId, this.events);
                    boolean shouldRetry = retryResult.shouldRetry;
                    if (!shouldRetry) break;
                    if (isLastTry) {
                        HttpTransport.this.triggerEventCallbacks(this.events, retryResult.statusCode, "Event retries exhausted.");
                        break;
                    }
                    boolean shouldReduceEventCount = retryResult.shouldReduceEventCount;
                    int[] eventIndicesToRemove = retryResult.eventIndicesToRemove;
                    if (eventIndicesToRemove.length > 0) {
                        eventsToDrop = new ArrayList();
                        for (int i = eventIndicesToRemove.length - 1; i >= 0; --i) {
                            int index = eventIndicesToRemove[i];
                            if (index >= eventCount) continue;
                            eventsToDrop.add(this.events.remove(index));
                        }
                        HttpTransport.this.triggerEventCallbacks(eventsToDrop, retryResult.statusCode, "Invalid events.");
                        continue;
                    }
                    if (!shouldReduceEventCount) continue;
                    eventsToDrop = this.events.subList(eventCount / 2, eventCount);
                    HttpTransport.this.triggerEventCallbacks(eventsToDrop, retryResult.statusCode, "Event dropped for retry");
                    this.events = this.events.subList(0, eventCount / 2);
                    continue;
                }
                catch (Exception e) {
                    HttpTransport.this.logger.error("RETRY", Utils.getStackTrace(e));
                    HttpTransport.this.triggerEventCallbacks(this.events, 0, "Retry threads Exception.");
                    Thread.currentThread().interrupt();
                }
            }
            if (HttpTransport.this.recordThrottledId) {
                Object object = HttpTransport.this.throttleLock;
                synchronized (object) {
                    HttpTransport.this.throttledUserId.remove(this.userId);
                    HttpTransport.this.throttledDeviceId.remove(this.deviceId);
                }
            }
        }
    }
}

