/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.AmplitudeCallbacks;
import com.amplitude.AmplitudeLog;
import com.amplitude.Event;
import com.amplitude.HttpCall;
import com.amplitude.HttpCallMode;
import com.amplitude.HttpTransport;
import com.amplitude.IngestionMetadata;
import com.amplitude.Middleware;
import com.amplitude.MiddlewareExtra;
import com.amplitude.MiddlewarePayload;
import com.amplitude.MiddlewareRunner;
import com.amplitude.Options;
import com.amplitude.Plan;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Amplitude {
    private static Map<String, Amplitude> instances = new HashMap<String, Amplitude>();
    private final String instanceName;
    private String apiKey;
    private String serverUrl;
    private AmplitudeLog logger;
    private Queue<Event> eventsToSend;
    private boolean aboutToStartFlushing;
    private HttpCallMode httpCallMode;
    private HttpCall httpCall;
    private HttpTransport httpTransport;
    private int eventUploadThreshold = 10;
    private int eventUploadPeriodMillis = 10000;
    private Object eventQueueLock = new Object();
    private Plan plan;
    private IngestionMetadata ingestionMetadata;
    private long flushTimeout;
    private Options options;
    private Proxy proxy = Proxy.NO_PROXY;
    MiddlewareRunner middlewareRunner = new MiddlewareRunner();

    private Amplitude(String name) {
        this.instanceName = name;
        this.logger = new AmplitudeLog();
        this.eventsToSend = new ConcurrentLinkedQueue<Event>();
        this.aboutToStartFlushing = false;
        this.httpTransport = new HttpTransport(this.httpCall, null, this.logger, this.flushTimeout);
    }

    public static Amplitude getInstance() {
        return Amplitude.getInstance("");
    }

    public static Amplitude getInstance(String instanceName) {
        if (!instances.containsKey(instanceName)) {
            Amplitude ampInstance = new Amplitude(instanceName);
            instances.put(instanceName, ampInstance);
        }
        return instances.get(instanceName);
    }

    public void init(String key) {
        this.apiKey = key;
        this.updateHttpCall(HttpCallMode.REGULAR);
    }

    public void setServerUrl(String url) {
        boolean isValidServerUrl;
        boolean bl = isValidServerUrl = url.startsWith("http://") || url.startsWith("https://");
        if (!isValidServerUrl) {
            return;
        }
        this.serverUrl = url;
        this.updateHttpCall(this.httpCallMode);
    }

    public void setOptions(Options options) {
        this.options = options;
        this.updateHttpCall(this.httpCallMode);
    }

    public void useBatchMode(Boolean isBatchMode) {
        this.updateHttpCall(isBatchMode != false ? HttpCallMode.BATCH : HttpCallMode.REGULAR);
    }

    public void setLogMode(AmplitudeLog.LogMode logMode) {
        this.logger.setLogMode(logMode);
    }

    public Amplitude setEventUploadThreshold(int eventUploadThreshold) {
        this.eventUploadThreshold = eventUploadThreshold;
        return this;
    }

    public Amplitude setEventUploadPeriodMillis(int eventUploadPeriodMillis) {
        this.eventUploadPeriodMillis = eventUploadPeriodMillis;
        return this;
    }

    public void setCallbacks(AmplitudeCallbacks callbacks) {
        this.httpTransport.setCallbacks(callbacks);
    }

    public Amplitude setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public Amplitude setIngestionMetadata(IngestionMetadata ingestionMetadata) {
        this.ingestionMetadata = ingestionMetadata;
        return this;
    }

    public Amplitude setProxy(Proxy proxy) {
        this.proxy = proxy;
        this.updateHttpCall(this.httpCallMode);
        return this;
    }

    public Amplitude setLogger(AmplitudeLog logger) {
        this.logger = logger;
        this.httpTransport.setLogger(logger);
        return this;
    }

    public Amplitude setFlushTimeout(long timeout) {
        this.flushTimeout = timeout;
        this.httpTransport.setFlushTimeout(timeout);
        return this;
    }

    public synchronized void addEventMiddleware(Middleware middleware) {
        this.middlewareRunner.add(middleware);
    }

    public void logEvent(Event event) {
        this.logEvent(event, null, null);
    }

    public void logEvent(Event event, MiddlewareExtra extra) {
        this.logEvent(event, null, extra);
    }

    public void logEvent(Event event, AmplitudeCallbacks callbacks) {
        this.logEvent(event, callbacks, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(Event event, AmplitudeCallbacks callbacks, MiddlewareExtra extra) {
        if (event.plan == null) {
            event.plan = this.plan;
        }
        if (event.ingestionMetadata == null) {
            event.ingestionMetadata = this.ingestionMetadata;
        }
        if (!this.middlewareRunner.run(new MiddlewarePayload(event, extra))) {
            return;
        }
        if (callbacks != null) {
            event.callback = callbacks;
        }
        int queueSize = 0;
        Object object = this.eventQueueLock;
        synchronized (object) {
            this.eventsToSend.add(event);
            queueSize = this.eventsToSend.size();
        }
        if (queueSize >= this.eventUploadThreshold) {
            this.flushEvents();
        } else {
            this.scheduleFlushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushEvents() {
        ArrayList<Event> eventsInTransit = new ArrayList<Event>();
        Object object = this.eventQueueLock;
        synchronized (object) {
            if (this.eventsToSend.size() > 0) {
                eventsInTransit.addAll(this.eventsToSend);
                this.eventsToSend.clear();
            }
        }
        if (!eventsInTransit.isEmpty()) {
            this.httpTransport.sendEventsWithRetry(eventsInTransit);
        }
    }

    public boolean shouldWait(Event event) {
        return this.eventsToSend.size() > this.eventUploadThreshold || this.httpTransport.shouldWait(event);
    }

    public void setRecordThrottledId(boolean record) {
        this.httpTransport.setRecordThrottledId(record);
    }

    public void shutdown() throws InterruptedException {
        this.httpTransport.shutdown();
        instances.remove(this.instanceName);
    }

    private void updateHttpCall(HttpCallMode updatedHttpCallMode) {
        this.httpCallMode = updatedHttpCallMode;
        this.httpCall = updatedHttpCallMode == HttpCallMode.BATCH ? new HttpCall(this.apiKey, this.serverUrl != null ? this.serverUrl : "https://api2.amplitude.com/batch", this.options, this.proxy) : new HttpCall(this.apiKey, this.serverUrl != null ? this.serverUrl : "https://api2.amplitude.com/2/httpapi", this.options, this.proxy);
        this.httpTransport.setHttpCall(this.httpCall);
    }

    private synchronized void scheduleFlushEvents() {
        if (!this.aboutToStartFlushing) {
            this.aboutToStartFlushing = true;
            Thread flushThread = new Thread(() -> {
                try {
                    Thread.sleep(this.eventUploadPeriodMillis);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Error schedule flush events.", e.getMessage());
                }
                this.flushEvents();
                this.aboutToStartFlushing = false;
            });
            flushThread.start();
        }
    }
}

