/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import com.amplitude.api.AmplitudeLog;
import com.amplitude.api.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class Revenue {
    private static final String TAG = Revenue.class.getName();
    private static AmplitudeLog logger = AmplitudeLog.getLogger();
    protected String productId = null;
    protected int quantity = 1;
    protected Double price = null;
    protected String revenueType = null;
    protected String receipt = null;
    protected String receiptSig = null;
    protected JSONObject properties = null;

    protected boolean isValidRevenue() {
        if (this.price == null) {
            logger.w(TAG, "Invalid revenue, need to set price");
            return false;
        }
        return true;
    }

    public Revenue setProductId(String productId) {
        if (Utils.isEmptyString(productId)) {
            logger.w(TAG, "Invalid empty productId");
            return this;
        }
        this.productId = productId;
        return this;
    }

    public Revenue setQuantity(int quantity) {
        this.quantity = quantity;
        return this;
    }

    public Revenue setPrice(double price) {
        this.price = price;
        return this;
    }

    public Revenue setRevenueType(String revenueType) {
        this.revenueType = revenueType;
        return this;
    }

    public Revenue setReceipt(String receipt, String receiptSignature) {
        this.receipt = receipt;
        this.receiptSig = receiptSignature;
        return this;
    }

    public Revenue setRevenueProperties(JSONObject revenueProperties) {
        logger.w(TAG, "setRevenueProperties is deprecated, please use setEventProperties instead");
        return this.setEventProperties(revenueProperties);
    }

    public Revenue setEventProperties(JSONObject eventProperties) {
        this.properties = Utils.cloneJSONObject(eventProperties);
        return this;
    }

    protected JSONObject toJSONObject() {
        JSONObject obj = this.properties == null ? new JSONObject() : this.properties;
        try {
            obj.put("$productId", (Object)this.productId);
            obj.put("$quantity", this.quantity);
            obj.put("$price", (Object)this.price);
            obj.put("$revenueType", (Object)this.revenueType);
            obj.put("$receipt", (Object)this.receipt);
            obj.put("$receiptSig", (Object)this.receiptSig);
        }
        catch (JSONException e) {
            logger.e(TAG, String.format("Failed to convert revenue object to JSON: %s", e.toString()));
        }
        return obj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Revenue revenue = (Revenue)o;
        if (this.quantity != revenue.quantity) {
            return false;
        }
        if (this.productId != null ? !this.productId.equals(revenue.productId) : revenue.productId != null) {
            return false;
        }
        if (this.price != null ? !this.price.equals(revenue.price) : revenue.price != null) {
            return false;
        }
        if (this.revenueType != null ? !this.revenueType.equals(revenue.revenueType) : revenue.revenueType != null) {
            return false;
        }
        if (this.receipt != null ? !this.receipt.equals(revenue.receipt) : revenue.receipt != null) {
            return false;
        }
        if (this.receiptSig != null ? !this.receiptSig.equals(revenue.receiptSig) : revenue.receiptSig != null) {
            return false;
        }
        return !(this.properties == null ? revenue.properties != null : !Utils.compareJSONObjects(this.properties, revenue.properties));
    }

    public int hashCode() {
        int result = this.productId != null ? this.productId.hashCode() : 0;
        result = 31 * result + this.quantity;
        result = 31 * result + (this.price != null ? this.price.hashCode() : 0);
        result = 31 * result + (this.revenueType != null ? this.revenueType.hashCode() : 0);
        result = 31 * result + (this.receipt != null ? this.receipt.hashCode() : 0);
        result = 31 * result + (this.receiptSig != null ? this.receiptSig.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

