/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import com.androidnetworking.common.ANLog;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.Priority;
import com.androidnetworking.common.ResponseType;
import com.androidnetworking.core.Core;
import com.androidnetworking.error.ANError;
import com.androidnetworking.internal.InternalNetworking;
import com.androidnetworking.utils.SourceCloseUtil;
import com.androidnetworking.utils.Utils;
import okhttp3.Response;

public class InternalRunnable
implements Runnable {
    private final Priority priority;
    public final int sequence;
    public final ANRequest request;

    public InternalRunnable(ANRequest request) {
        this.request = request;
        this.sequence = request.getSequenceNumber();
        this.priority = request.getPriority();
    }

    @Override
    public void run() {
        ANLog.d("execution started : " + this.request.toString());
        switch (this.request.getRequestType()) {
            case 0: {
                this.executeSimpleRequest();
                break;
            }
            case 1: {
                this.executeDownloadRequest();
                break;
            }
            case 2: {
                this.executeUploadRequest();
            }
        }
        ANLog.d("execution done : " + this.request.toString());
    }

    private void executeSimpleRequest() {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performSimpleRequest(this.request);
            if (okHttpResponse == null) {
                this.deliverError(this.request, Utils.getErrorForConnection(new ANError()));
                return;
            }
            if (this.request.getResponseAs() == ResponseType.OK_HTTP_RESPONSE) {
                this.request.deliverOkHttpResponse(okHttpResponse);
                return;
            }
            if (okHttpResponse.code() >= 400) {
                this.deliverError(this.request, Utils.getErrorForServerResponse(new ANError(okHttpResponse), this.request, okHttpResponse.code()));
                return;
            }
            ANResponse response = this.request.parseResponse(okHttpResponse);
            if (!response.isSuccess()) {
                this.deliverError(this.request, response.getError());
                return;
            }
            response.setOkHttpResponse(okHttpResponse);
            this.request.deliverResponse(response);
        }
        catch (Exception e) {
            this.deliverError(this.request, Utils.getErrorForConnection(new ANError(e)));
        }
        finally {
            SourceCloseUtil.close(okHttpResponse, this.request);
        }
    }

    private void executeDownloadRequest() {
        try {
            Response okHttpResponse = InternalNetworking.performDownloadRequest(this.request);
            if (okHttpResponse == null) {
                this.deliverError(this.request, Utils.getErrorForConnection(new ANError()));
                return;
            }
            if (okHttpResponse.code() >= 400) {
                this.deliverError(this.request, Utils.getErrorForServerResponse(new ANError(okHttpResponse), this.request, okHttpResponse.code()));
                return;
            }
            this.request.updateDownloadCompletion();
        }
        catch (Exception e) {
            this.deliverError(this.request, Utils.getErrorForConnection(new ANError(e)));
        }
    }

    private void executeUploadRequest() {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performUploadRequest(this.request);
            if (okHttpResponse == null) {
                this.deliverError(this.request, Utils.getErrorForConnection(new ANError()));
                return;
            }
            if (this.request.getResponseAs() == ResponseType.OK_HTTP_RESPONSE) {
                this.request.deliverOkHttpResponse(okHttpResponse);
                return;
            }
            if (okHttpResponse.code() >= 400) {
                this.deliverError(this.request, Utils.getErrorForServerResponse(new ANError(okHttpResponse), this.request, okHttpResponse.code()));
                return;
            }
            ANResponse response = this.request.parseResponse(okHttpResponse);
            if (!response.isSuccess()) {
                this.deliverError(this.request, response.getError());
                return;
            }
            response.setOkHttpResponse(okHttpResponse);
            this.request.deliverResponse(response);
        }
        catch (Exception e) {
            this.deliverError(this.request, Utils.getErrorForConnection(new ANError(e)));
        }
        finally {
            SourceCloseUtil.close(okHttpResponse, this.request);
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    private void deliverError(final ANRequest request, final ANError anError) {
        Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

            @Override
            public void run() {
                request.deliverError(anError);
                request.finish();
            }
        });
    }
}

