/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import com.androidnetworking.common.ANLog;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.RESPONSE;
import com.androidnetworking.error.ANError;
import com.androidnetworking.internal.InternalNetworking;
import okhttp3.Response;

public final class SynchronousCall {
    private SynchronousCall() {
    }

    public static <T> ANResponse<T> getResponse(ANRequest request) {
        switch (request.getRequestType()) {
            case 0: {
                return SynchronousCall.executeSimpleRequest(request);
            }
            case 1: {
                return SynchronousCall.executeDownloadRequest(request);
            }
            case 2: {
                return SynchronousCall.executeUploadRequest(request);
            }
        }
        return new ANResponse(new ANError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ANResponse<T> executeSimpleRequest(ANRequest request) {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performSimpleRequest(request);
            if (okHttpResponse == null) {
                ANError anError = new ANError();
                anError = request.parseNetworkError(anError);
                anError.setErrorDetail("connectionError");
                anError.setErrorCode(0);
                ANResponse aNResponse = new ANResponse(anError);
                return aNResponse;
            }
            if (request.getResponseAs() == RESPONSE.OK_HTTP_RESPONSE) {
                ANResponse<Response> anError = new ANResponse<Response>(okHttpResponse);
                return anError;
            }
            if (okHttpResponse.code() >= 400) {
                ANError anError = new ANError(okHttpResponse);
                anError = request.parseNetworkError(anError);
                anError.setErrorCode(okHttpResponse.code());
                anError.setErrorDetail("responseFromServerError");
                ANResponse e = new ANResponse(anError);
                return e;
            }
            ANResponse anError = request.parseResponse(okHttpResponse);
            return anError;
        }
        catch (ANError se) {
            se = request.parseNetworkError(se);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            ANResponse e = new ANResponse(se);
            return e;
        }
        catch (Exception e) {
            ANError se = new ANError(e);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            ANResponse aNResponse = new ANResponse(se);
            return aNResponse;
        }
        finally {
            if (request.getResponseAs() != RESPONSE.OK_HTTP_RESPONSE && okHttpResponse != null && okHttpResponse.body() != null && okHttpResponse.body().source() != null) {
                try {
                    okHttpResponse.body().source().close();
                }
                catch (Exception e) {
                    ANLog.d("Unable to close source data");
                }
            }
        }
    }

    private static <T> ANResponse<T> executeDownloadRequest(ANRequest request) {
        try {
            Response okHttpResponse = InternalNetworking.performDownloadRequest(request);
            if (okHttpResponse == null) {
                ANError anError = new ANError();
                anError = request.parseNetworkError(anError);
                anError.setErrorDetail("connectionError");
                anError.setErrorCode(0);
                return new ANResponse(anError);
            }
            if (okHttpResponse.code() >= 400) {
                ANError anError = new ANError();
                anError = request.parseNetworkError(anError);
                anError.setErrorCode(okHttpResponse.code());
                anError.setErrorDetail("responseFromServerError");
                return new ANResponse(anError);
            }
            return new ANResponse<String>("success");
        }
        catch (ANError se) {
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            return new ANResponse(se);
        }
        catch (Exception e) {
            ANError se = new ANError(e);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            return new ANResponse(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ANResponse<T> executeUploadRequest(ANRequest request) {
        Response okHttpResponse = null;
        try {
            okHttpResponse = InternalNetworking.performUploadRequest(request);
            if (okHttpResponse == null) {
                ANError anError = new ANError();
                anError = request.parseNetworkError(anError);
                anError.setErrorDetail("connectionError");
                anError.setErrorCode(0);
                ANResponse aNResponse = new ANResponse(anError);
                return aNResponse;
            }
            if (request.getResponseAs() == RESPONSE.OK_HTTP_RESPONSE) {
                ANResponse<Response> anError = new ANResponse<Response>(okHttpResponse);
                return anError;
            }
            if (okHttpResponse.code() >= 400) {
                ANError anError = new ANError(okHttpResponse);
                anError = request.parseNetworkError(anError);
                anError.setErrorCode(okHttpResponse.code());
                anError.setErrorDetail("responseFromServerError");
                ANResponse e = new ANResponse(anError);
                return e;
            }
            ANResponse anError = request.parseResponse(okHttpResponse);
            return anError;
        }
        catch (ANError se) {
            se = request.parseNetworkError(se);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            ANResponse e = new ANResponse(se);
            return e;
        }
        catch (Exception e) {
            ANError se = new ANError(e);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            ANResponse aNResponse = new ANResponse(se);
            return aNResponse;
        }
        finally {
            if (request.getResponseAs() != RESPONSE.OK_HTTP_RESPONSE && okHttpResponse != null && okHttpResponse.body() != null && okHttpResponse.body().source() != null) {
                try {
                    okHttpResponse.body().source().close();
                }
                catch (Exception e) {
                    ANLog.d("Unable to close source data");
                }
            }
        }
    }
}

