/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.androidnetworking.interfaces.DownloadProgressListener;
import com.androidnetworking.model.Progress;
import java.lang.ref.WeakReference;

public class DownloadProgressHandler
extends Handler {
    private final WeakReference<DownloadProgressListener> mDownloadProgressListenerWeakRef;

    public DownloadProgressHandler(DownloadProgressListener downloadProgressListener) {
        super(Looper.getMainLooper());
        this.mDownloadProgressListenerWeakRef = new WeakReference<DownloadProgressListener>(downloadProgressListener);
    }

    public void handleMessage(Message msg) {
        DownloadProgressListener downloadProgressListener = (DownloadProgressListener)this.mDownloadProgressListenerWeakRef.get();
        switch (msg.what) {
            case 1: {
                if (downloadProgressListener == null) break;
                Progress progress = (Progress)msg.obj;
                downloadProgressListener.onProgress(progress.currentBytes, progress.totalBytes);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }
}

