/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import com.androidnetworking.interfaces.Parser;
import com.androidnetworking.internal.GsonRequestBodyParser;
import com.androidnetworking.internal.GsonResponseBodyParser;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public final class GsonParserFactory
extends Parser.Factory {
    private static GsonParserFactory sInstance = null;
    private final Gson gson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GsonParserFactory getInstance() {
        if (sInstance != null) return sInstance;
        Class<GsonParserFactory> clazz = GsonParserFactory.class;
        synchronized (GsonParserFactory.class) {
            if (sInstance != null) return sInstance;
            sInstance = new GsonParserFactory(new Gson());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private GsonParserFactory(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Parser<ResponseBody, ?> responseBodyParser(Type type) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonResponseBodyParser(this.gson, adapter);
    }

    @Override
    public Parser<?, RequestBody> requestBodyParser(Type type) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonRequestBodyParser(this.gson, adapter);
    }

    public static void shutDown() {
        if (sInstance != null) {
            sInstance = null;
        }
    }
}

