/*
 * Decompiled with CFR 0.152.
 */
package com.aminyazdanpanah.maps.android.charts;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import java.util.Arrays;

public class PieChart
extends Drawable {
    private Paint paint = new Paint(1);
    private float[] value_degree;
    private final float[] value_real;
    private int[] COLORS;
    private RectF rectf = new RectF(PieChart.convertDpToPixel(20.0f), PieChart.convertDpToPixel(17.0f), PieChart.convertDpToPixel(80.0f), PieChart.convertDpToPixel(57.0f));
    private RectF rect = new RectF(PieChart.convertDpToPixel(20.0f), PieChart.convertDpToPixel(17.0f), PieChart.convertDpToPixel(80.0f), PieChart.convertDpToPixel(67.0f));
    private int temp = 0;

    PieChart(float[] values, int[] colors) {
        this.COLORS = Arrays.copyOf(colors, colors.length);
        this.value_real = Arrays.copyOf(values, values.length);
        this.value_degree = this.calculateData(values);
    }

    public void draw(@NonNull Canvas canvas) {
        this.paint.setColor(-16777216);
        this.paint.setShadowLayer(10.0f, 0.0f, 2.0f, -16777216);
        this.paint.setStrokeWidth(100.0f);
        this.paint.setColor(-1435011209);
        canvas.drawOval(this.rect, this.paint);
        for (int i = 0; i < this.value_degree.length; ++i) {
            if (i != 0) {
                this.temp = (int)((float)this.temp + this.value_degree[i - 1]);
            }
            this.paint.setShadowLayer(10.0f, 0.0f, 2.0f, -16777216);
            this.paint.setColor(this.COLORS[i]);
            canvas.drawArc(this.rectf, (float)this.temp, this.value_degree[i], true, this.paint);
            this.paint.setColor(-16777216);
            this.paint.setTextSize(PieChart.convertDpToPixel(13.0f));
            if (this.value_real[i] == 0.0f) continue;
            double x = 40.0 * Math.cos(Math.toRadians((float)this.temp + this.value_degree[i] / 2.0f)) + 45.0;
            double y = 35.0 * Math.sin(Math.toRadians((float)this.temp + this.value_degree[i] / 2.0f)) + 45.0;
            canvas.drawText((int)this.value_real[i] + "", PieChart.convertDpToPixel((int)x), PieChart.convertDpToPixel((int)y), this.paint);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    private static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return Math.round(px);
    }

    private float[] calculateData(float[] data) {
        int total = 0;
        for (float aData : data) {
            total = (int)((float)total + aData);
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = 360.0f * (data[i] / (float)total);
        }
        return data;
    }
}

