/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.proxy.InitializationTypeHelper;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.AwsSpringHttpProcessingUtils;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.cloud.function.serverless.web.FunctionClassUtils;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;

public class SpringDelegatingLambdaContainerHandler
implements RequestStreamHandler {
    private final Class<?>[] startupClasses;
    private final ServerlessMVC mvc;
    private final ObjectMapper mapper;
    private final AwsProxyHttpServletResponseWriter responseWriter;

    public SpringDelegatingLambdaContainerHandler() {
        this(FunctionClassUtils.getStartClass());
    }

    public SpringDelegatingLambdaContainerHandler(Class<?> ... startupClasses) {
        this.startupClasses = startupClasses;
        this.mvc = ServerlessMVC.INSTANCE((Class[])this.startupClasses);
        if (InitializationTypeHelper.isAsyncInitializationDisabled()) {
            this.mvc.waitForContext();
        }
        this.mapper = new ObjectMapper();
        this.responseWriter = new AwsProxyHttpServletResponseWriter();
    }

    public void handleRequest(InputStream input, OutputStream output, Context lambdaContext) throws IOException {
        HttpServletRequest httpServletRequest = AwsSpringHttpProcessingUtils.generateHttpServletRequest(input, lambdaContext, this.mvc.getServletContext(), this.mapper);
        AwsProxyResponse awsProxyResponse = AwsSpringHttpProcessingUtils.processRequest(httpServletRequest, this.mvc, this.responseWriter);
        this.mapper.writeValue(output, (Object)awsProxyResponse);
    }
}

