/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.InternalServerErrorException;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JerseyServletResponseWriter
implements ContainerResponseWriter {
    private HttpServletResponse servletResponse;
    private Logger log = LoggerFactory.getLogger(JerseyServletResponseWriter.class);
    private CountDownLatch jerseyLatch;

    public JerseyServletResponseWriter(ServletResponse resp, CountDownLatch latch) {
        assert (resp instanceof HttpServletResponse);
        this.servletResponse = (HttpServletResponse)resp;
        this.jerseyLatch = latch;
    }

    @SuppressFBWarnings(value={"HTTP_RESPONSE_SPLITTING"})
    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse containerResponse) throws ContainerException {
        Timer.start((String)"JERSEY_WRITE_RESPONSE");
        this.servletResponse.setStatus(containerResponse.getStatusInfo().getStatusCode());
        for (Map.Entry e : containerResponse.getStringHeaders().entrySet()) {
            for (String value : (List)e.getValue()) {
                this.servletResponse.setHeader((String)e.getKey(), value);
            }
        }
        try {
            Timer.stop((String)"JERSEY_WRITE_RESPONSE");
            return this.servletResponse.getOutputStream();
        }
        catch (IOException e) {
            this.log.error("Could not get servlet response output stream", (Throwable)e);
            Timer.stop((String)"JERSEY_WRITE_RESPONSE");
            throw new InternalServerErrorException("Could not get servlet response output stream", (Throwable)e);
        }
    }

    public boolean suspend(long l, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        this.log.debug("Suspend");
        return false;
    }

    public void setSuspendTimeout(long l, TimeUnit timeUnit) throws IllegalStateException {
        this.log.debug("SuspectTimeout");
    }

    public void commit() {
        try {
            this.log.debug("commit");
            this.jerseyLatch.countDown();
            this.servletResponse.flushBuffer();
        }
        catch (IOException e) {
            this.log.error("Could not commit response", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void failure(Throwable throwable) {
        try {
            this.log.error("failure", throwable);
            this.jerseyLatch.countDown();
            this.servletResponse.flushBuffer();
        }
        catch (IOException e) {
            this.log.error("Could not fail response", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public boolean enableResponseBuffering() {
        return false;
    }
}

