/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.jersey.JerseyHandlerFilter;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;

public class JerseyLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, AwsProxyHttpServletRequest, AwsHttpServletResponse> {
    private Application jaxRsApplication;
    private JerseyHandlerFilter jerseyFilter;
    private boolean initialized;

    public static JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Application jaxRsApplication) {
        return new JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>((RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), jaxRsApplication);
    }

    public JerseyLambdaContainerHandler(RequestReader<RequestType, AwsProxyHttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, Application jaxRsApplication) {
        super(requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)"JERSEY_CONTAINER_CONSTRUCTOR");
        this.jaxRsApplication = jaxRsApplication;
        this.initialized = false;
        this.jerseyFilter = new JerseyHandlerFilter(this.jaxRsApplication);
        Timer.stop((String)"JERSEY_CONTAINER_CONSTRUCTOR");
    }

    protected AwsHttpServletResponse getContainerResponse(AwsProxyHttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse((AwsHttpServletRequest)request, latch);
    }

    protected void handleRequest(AwsProxyHttpServletRequest httpServletRequest, AwsHttpServletResponse httpServletResponse, Context lambdaContext) throws Exception {
        Timer.start((String)"JERSEY_HANDLE_REQUEST");
        super.handleRequest((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, lambdaContext);
        if (!this.initialized) {
            Timer.start((String)"JERSEY_COLD_START_INIT");
            if (this.startupHandler != null) {
                this.startupHandler.onStartup(this.getServletContext());
            }
            FilterRegistration.Dynamic jerseyFilterReg = this.getServletContext().addFilter("JerseyFilter", (Filter)this.jerseyFilter);
            jerseyFilterReg.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
            this.initialized = true;
            Timer.stop((String)"JERSEY_COLD_START_INIT");
        }
        httpServletRequest.setServletContext(this.getServletContext());
        this.doFilter((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null);
        Timer.stop((String)"JERSEY_HANDLE_REQUEST");
    }
}

