/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class JerseyResponseWriter
implements ContainerResponseWriter {
    private CountDownLatch responseMutex;
    private Map<String, String> headers;
    private int statusCode;
    private ByteArrayOutputStream responseBody;

    JerseyResponseWriter(CountDownLatch latch) {
        this.responseMutex = latch;
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse containerResponse) throws ContainerException {
        this.statusCode = containerResponse.getStatusInfo().getStatusCode();
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        for (Map.Entry e : containerResponse.getStringHeaders().entrySet()) {
            for (String value : (List)e.getValue()) {
                this.headers.put((String)e.getKey(), value);
            }
        }
        this.responseBody = new ByteArrayOutputStream();
        return this.responseBody;
    }

    public boolean suspend(long l, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        return false;
    }

    public void setSuspendTimeout(long l, TimeUnit timeUnit) throws IllegalStateException {
    }

    public void commit() {
        this.responseMutex.countDown();
    }

    public void failure(Throwable throwable) {
        this.responseMutex.countDown();
    }

    public boolean enableResponseBuffering() {
        return false;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    ByteArrayOutputStream getResponseBody() {
        return this.responseBody;
    }
}

