/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching.cache;

import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheObject;
import java.util.Objects;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretCacheVersion
extends SecretCacheObject<GetSecretValueResponse> {
    private final String versionId;
    private final int hash;

    public SecretCacheVersion(String secretId, String versionId, SecretsManagerClient client, SecretCacheConfiguration config) {
        super(secretId, client, config);
        this.versionId = versionId;
        this.hash = String.format("%s %s", secretId, versionId).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SecretCacheVersion) {
            return Objects.equals(this.secretId, ((SecretCacheVersion)obj).secretId) && Objects.equals(this.versionId, ((SecretCacheVersion)obj).versionId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        return String.format("SecretCacheVersion: %s %s", this.secretId, this.versionId);
    }

    @Override
    protected GetSecretValueResponse executeRefresh() {
        return this.client.getSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.secretId).versionId(this.versionId).build());
    }

    @Override
    protected GetSecretValueResponse getSecretValue(GetSecretValueResponse gsvResult) {
        return gsvResult;
    }
}

