/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching.cache;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SecretCacheObject<T> {
    private static final long EXCEPTION_BACKOFF = 1000L;
    private static final long EXCEPTION_BACKOFF_GROWTH_FACTOR = 2L;
    private static final long BACKOFF_PLATEAU = 128000L;
    private static final long FORCE_REFRESH_JITTER_SLEEP = 5000L;
    protected final String secretId;
    protected final Object lock = new Object();
    protected final AWSSecretsManager client;
    protected final SecretCacheConfiguration config;
    private AtomicBoolean refreshNeeded = new AtomicBoolean(true);
    private Object data = null;
    protected RuntimeException exception = null;
    private long exceptionBackoffPower = 0L;
    private long nextRetryTime = 0L;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SecretCacheObject(String secretId, AWSSecretsManager client, SecretCacheConfiguration config) {
        this.secretId = secretId;
        this.client = client;
        this.config = config;
    }

    protected abstract T executeRefresh();

    protected abstract GetSecretValueResult getSecretValue(T var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    protected <U extends AmazonWebServiceRequest> U updateUserAgent(U request) {
        request.getRequestClientOptions().appendUserAgent("AwsSecretCache/1.1.0");
        return request;
    }

    private T getResult() {
        if (null != this.config.getCacheHook()) {
            return (T)this.config.getCacheHook().get(this.data);
        }
        return (T)this.data;
    }

    private void setResult(T result) {
        this.data = null != this.config.getCacheHook() ? this.config.getCacheHook().put(result) : result;
    }

    protected boolean isRefreshNeeded() {
        if (this.refreshNeeded.get()) {
            return true;
        }
        if (null != this.exception) {
            return System.currentTimeMillis() >= this.nextRetryTime;
        }
        return false;
    }

    private void refresh() {
        if (!this.isRefreshNeeded()) {
            return;
        }
        this.refreshNeeded.set(false);
        try {
            this.setResult(this.executeRefresh());
            this.exception = null;
            this.exceptionBackoffPower = 0L;
        }
        catch (RuntimeException ex) {
            Long retryWait;
            this.exception = ex;
            Long growth = 1L;
            if (this.exceptionBackoffPower > 0L) {
                growth = (long)Math.pow(2.0, this.exceptionBackoffPower);
            }
            if ((retryWait = Long.valueOf(Math.min(1000L + (growth = Long.valueOf(growth * 1000L)), 128000L))) < 128000L) {
                ++this.exceptionBackoffPower;
            }
            retryWait = ThreadLocalRandom.current().nextLong(retryWait / 2L, retryWait + 1L);
            this.nextRetryTime = System.currentTimeMillis() + retryWait;
        }
    }

    private List<String> clone(List<String> l) {
        if (null == l) {
            return null;
        }
        return new ArrayList<String>(l);
    }

    private ByteBuffer clone(ByteBuffer b) {
        if (null == b) {
            return null;
        }
        b.rewind();
        ByteBuffer clone = ByteBuffer.allocate(b.remaining());
        if (b.hasArray()) {
            System.arraycopy(b.array(), 0, clone.array(), 0, b.remaining());
        } else {
            clone.put(b.duplicate());
            clone.flip();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshNow() throws InterruptedException {
        this.refreshNeeded.set(true);
        long sleep = ThreadLocalRandom.current().nextLong(2500L, 5001L);
        if (null != this.exception) {
            long wait = this.nextRetryTime - System.currentTimeMillis();
            sleep = Math.max(wait, sleep);
        }
        Thread.sleep(sleep);
        Object object = this.lock;
        synchronized (object) {
            this.refresh();
            return null == this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"})
    public GetSecretValueResult getSecretValue() {
        Object object = this.lock;
        synchronized (object) {
            this.refresh();
            if (null == this.data && null != this.exception) {
                throw this.exception;
            }
            GetSecretValueResult gsv = this.getSecretValue(this.getResult());
            if (null == gsv) {
                return null;
            }
            gsv = gsv.clone();
            gsv.setSecretBinary(this.clone(gsv.getSecretBinary()));
            gsv.setVersionStages(this.clone(gsv.getVersionStages()));
            return gsv;
        }
    }
}

