/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;
import software.amazon.awssdk.services.kinesis.model.Shard;

public class ShardGraphTracker {
    private final Map<String, Shard> shardByShardId = new HashMap<String, Shard>();
    private static final String END_SEQUENCE_NUMBER_TO_CLOSE_OPEN_PARENT = String.valueOf(Long.MAX_VALUE);

    public void collectShards(List<Shard> shards) {
        if (shards != null && !shards.isEmpty()) {
            shards.forEach(shard -> this.shardByShardId.put(shard.shardId(), (Shard)shard));
        }
    }

    public void closeOpenParents() {
        Set parentShardIds = this.shardByShardId.values().stream().map(Shard::parentShardId).filter(Objects::nonNull).collect(Collectors.toSet());
        this.shardByShardId.forEach((shardId, shard) -> {
            if (this.isOpenParentWithChildren((Shard)shard, parentShardIds)) {
                this.shardByShardId.put((String)shardId, this.createUpdatedShard((Shard)shard, END_SEQUENCE_NUMBER_TO_CLOSE_OPEN_PARENT));
            }
        });
    }

    public void markLeafShardsActive() {
        Set parentShardIds = this.shardByShardId.values().stream().map(Shard::parentShardId).filter(Objects::nonNull).collect(Collectors.toSet());
        this.shardByShardId.forEach((shardId, shard) -> {
            if (!parentShardIds.contains(shardId)) {
                this.shardByShardId.put((String)shardId, this.createUpdatedShard((Shard)shard, null));
            }
        });
    }

    private Shard createUpdatedShard(Shard original, String endSequenceNumber) {
        SequenceNumberRange newRange = (SequenceNumberRange)SequenceNumberRange.builder().startingSequenceNumber(original.sequenceNumberRange().startingSequenceNumber()).endingSequenceNumber(endSequenceNumber).build();
        return (Shard)Shard.builder().shardId(original.shardId()).parentShardId(original.parentShardId()).sequenceNumberRange(newRange).hashKeyRange(original.hashKeyRange()).adjacentParentShardId(original.adjacentParentShardId()).build();
    }

    private boolean isOpenParentWithChildren(Shard shard, Set<String> parentShardIds) {
        return parentShardIds.contains(shard.shardId()) && this.isShardOpen(shard);
    }

    private boolean isShardOpen(Shard shard) {
        return shard.sequenceNumberRange() != null && shard.sequenceNumberRange().endingSequenceNumber() == null;
    }

    public List<Shard> getShards() {
        return new ArrayList<Shard>(this.shardByShardId.values());
    }
}

