/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueDeserializer
extends JsonDeserializer<AttributeValue> {
    public AttributeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        return this.parseAttributeValue(node);
    }

    private AttributeValue parseAttributeValue(JsonNode node) throws IOException {
        AttributeValue.Builder builder = AttributeValue.builder();
        if (node.has("S")) {
            return (AttributeValue)builder.s(node.get("S").asText()).build();
        }
        if (node.has("N")) {
            return (AttributeValue)builder.n(node.get("N").asText()).build();
        }
        if (node.has("B")) {
            byte[] binaryData = node.get("B").binaryValue();
            return (AttributeValue)builder.b(SdkBytes.fromByteArray((byte[])binaryData)).build();
        }
        if (node.has("BOOL")) {
            return (AttributeValue)builder.bool(Boolean.valueOf(node.get("BOOL").asBoolean())).build();
        }
        if (node.has("NULL")) {
            return (AttributeValue)builder.nul(Boolean.valueOf(node.get("NULL").asBoolean())).build();
        }
        if (node.has("SS")) {
            JsonNode ssNode = node.get("SS");
            ArrayList<String> ss = new ArrayList<String>();
            for (JsonNode item : ssNode) {
                ss.add(item.asText());
            }
            return (AttributeValue)builder.ss(ss).build();
        }
        if (node.has("NS")) {
            JsonNode nsNode = node.get("NS");
            ArrayList<String> ns = new ArrayList<String>();
            for (JsonNode item : nsNode) {
                ns.add(item.asText());
            }
            return (AttributeValue)builder.ns(ns).build();
        }
        if (node.has("BS")) {
            JsonNode bsNode = node.get("BS");
            ArrayList<SdkBytes> bs = new ArrayList<SdkBytes>();
            for (JsonNode item : bsNode) {
                bs.add(SdkBytes.fromByteArray((byte[])item.binaryValue()));
            }
            return (AttributeValue)builder.bs(bs).build();
        }
        if (node.has("M")) {
            JsonNode mapNode = node.get("M");
            HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
            Iterator fields = mapNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                map.put((String)field.getKey(), this.parseAttributeValue((JsonNode)field.getValue()));
            }
            return (AttributeValue)builder.m(map).build();
        }
        if (node.has("L")) {
            JsonNode listNode = node.get("L");
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
            for (JsonNode item : listNode) {
                list.add(this.parseAttributeValue(item));
            }
            return (AttributeValue)builder.l(list).build();
        }
        return (AttributeValue)builder.build();
    }
}

