/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.adapter.DynamoDBStreamsGetRecordsResponseAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.common.DynamoDBStreamsRequestsBuilder;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.AmazonServiceExceptionTransformer;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.KinesisMapperUtil;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetryStrategy;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.retries.StandardRetryStrategy;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ShardFilter;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisServiceClientConfiguration;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class AmazonDynamoDBStreamsAdapterClient
implements KinesisAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(AmazonDynamoDBStreamsAdapterClient.class);
    private SkipRecordsBehavior skipRecordsBehavior = SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON;
    private static final int MAX_DESCRIBE_STREAM_RETRY_ATTEMPTS = 50;
    private static final Duration DESCRIBE_STREAM_CALLS_DELAY = Duration.ofMillis(1000L);
    private static final String KCL_CONSUMER_ID_PREFIX = "KCL-ConsumerId";
    private Region region;
    private final DynamoDbStreamsClient internalClient;
    private final Sleeper sleeper;

    public AmazonDynamoDBStreamsAdapterClient(AwsCredentialsProvider credentialsProvider, Region region) {
        BackoffStrategy backoffStrategy = BackoffStrategy.exponentialDelay((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(10000L));
        StandardRetryStrategy retryStrategy = ((StandardRetryStrategy.Builder)((StandardRetryStrategy.Builder)((StandardRetryStrategy.Builder)SdkDefaultRetryStrategy.standardRetryStrategy().toBuilder().maxAttempts(10)).backoffStrategy(backoffStrategy)).throttlingBackoffStrategy(backoffStrategy)).build();
        this.internalClient = (DynamoDbStreamsClient)((DynamoDbStreamsClientBuilder)((DynamoDbStreamsClientBuilder)((DynamoDbStreamsClientBuilder)DynamoDbStreamsClient.builder().credentialsProvider(credentialsProvider)).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryStrategy((RetryStrategy)retryStrategy).build())).region(region)).build();
        this.region = region;
        this.sleeper = new Sleeper();
    }

    public AmazonDynamoDBStreamsAdapterClient(DynamoDbStreamsClient dynamoDbStreamsClient, Region region) {
        this.internalClient = dynamoDbStreamsClient;
        this.region = region;
        this.sleeper = new Sleeper();
    }

    @VisibleForTesting
    protected AmazonDynamoDBStreamsAdapterClient(DynamoDbStreamsClient client) {
        this.internalClient = client;
        this.sleeper = new Sleeper();
    }

    public String serviceName() {
        return this.internalClient.serviceName();
    }

    public void close() {
        this.internalClient.close();
    }

    public CompletableFuture<software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) throws AwsServiceException, SdkClientException {
        String consumerId = this.getConsumerId(describeStreamRequest.overrideConfiguration());
        return CompletableFuture.supplyAsync(() -> {
            DescribeStreamResponse result;
            software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest ddbDescribeStreamRequest = (software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest)DynamoDBStreamsRequestsBuilder.describeStreamRequestBuilder(consumerId).streamArn(describeStreamRequest.streamName()).limit(describeStreamRequest.limit()).exclusiveStartShardId(describeStreamRequest.exclusiveStartShardId()).build();
            try {
                result = this.describeStreamWithRetries(ddbDescribeStreamRequest);
            }
            catch (AwsServiceException e) {
                throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisDescribeStream(e);
            }
            return KinesisMapperUtil.convertDynamoDBDescribeStreamResponseToKinesisDescribeStreamResponse(result);
        });
    }

    private String getConsumerId(Optional<AwsRequestOverrideConfiguration> overrideConfiguration) {
        return overrideConfiguration.map(RequestOverrideConfiguration::apiNames).orElse(Collections.emptyList()).stream().map(ApiName::name).filter(name -> name.contains(KCL_CONSUMER_ID_PREFIX)).findFirst().orElse("");
    }

    public CompletableFuture<software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws AwsServiceException, SdkClientException {
        return CompletableFuture.supplyAsync(() -> this.getShardIteratorResponse(getShardIteratorRequest));
    }

    private software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse getShardIteratorResponse(GetShardIteratorRequest getShardIteratorRequest) throws AwsServiceException, SdkClientException {
        GetShardIteratorResponse result;
        String consumerId = this.getConsumerId(getShardIteratorRequest.overrideConfiguration());
        software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest ddbGetShardIteratorRequest = (software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest)DynamoDBStreamsRequestsBuilder.getShardIteratorRequestBuilder(consumerId).streamArn(getShardIteratorRequest.streamName()).shardIteratorType(getShardIteratorRequest.shardIteratorTypeAsString()).shardId(getShardIteratorRequest.shardId()).sequenceNumber(getShardIteratorRequest.startingSequenceNumber()).build();
        try {
            result = this.internalClient.getShardIterator(ddbGetShardIteratorRequest);
        }
        catch (TrimmedDataAccessException e) {
            if (this.skipRecordsBehavior == SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) {
                if (getShardIteratorRequest.shardIteratorType().equals((Object)ShardIteratorType.TRIM_HORIZON)) {
                    throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator((AwsServiceException)((Object)e), this.skipRecordsBehavior);
                }
                log.warn("Data has been trimmed. Intercepting DynamoDB exception and retrieving a fresh iterator {}", (Object)getShardIteratorRequest, (Object)e);
                return this.getShardIteratorResponse((GetShardIteratorRequest)getShardIteratorRequest.toBuilder().shardIteratorType(ShardIteratorType.TRIM_HORIZON).startingSequenceNumber(null).build());
            }
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator((AwsServiceException)((Object)e), this.skipRecordsBehavior);
        }
        catch (AwsServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator(e, this.skipRecordsBehavior);
        }
        return KinesisMapperUtil.convertDynamoDBGetShardIteratorResponseToKinesisGetShardIteratorResponse(result);
    }

    public KinesisServiceClientConfiguration serviceClientConfiguration() {
        return KinesisServiceClientConfiguration.builder().region(this.region).build();
    }

    public CompletableFuture<software.amazon.awssdk.services.kinesis.model.ListStreamsResponse> listStreams(software.amazon.awssdk.services.kinesis.model.ListStreamsRequest listStreamsRequest) throws AwsServiceException, SdkClientException {
        return CompletableFuture.supplyAsync(() -> {
            ListStreamsRequest ddbListStreamsRequest = (ListStreamsRequest)DynamoDBStreamsRequestsBuilder.listStreamsRequestBuilder().limit(listStreamsRequest.limit()).exclusiveStartStreamArn(listStreamsRequest.exclusiveStartStreamName()).build();
            try {
                ListStreamsResponse listStreamsResponse = this.internalClient.listStreams(ddbListStreamsRequest);
                return KinesisMapperUtil.convertDynamoDBListStreamsResponseToKinesisListStreamsResponse(listStreamsResponse);
            }
            catch (AwsServiceException e) {
                throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisListStreams(e);
            }
        });
    }

    public CompletableFuture<GetRecordsResponse> getRecords(software.amazon.awssdk.services.kinesis.model.GetRecordsRequest getRecordsRequest) throws AwsServiceException, SdkClientException {
        throw new UnsupportedOperationException("DDB Adapter does not implement kinesis getrecords. See getDynamoDBStreamsRecords function");
    }

    public CompletableFuture<DynamoDBStreamsGetRecordsResponseAdapter> getDynamoDBStreamsRecords(GetRecordsRequest ddbGetRecordsRequest) throws AwsServiceException, SdkClientException {
        return CompletableFuture.supplyAsync(() -> {
            software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse result;
            try {
                result = this.internalClient.getRecords(ddbGetRecordsRequest);
            }
            catch (AwsServiceException e) {
                throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetRecords(e, this.skipRecordsBehavior);
            }
            return new DynamoDBStreamsGetRecordsResponseAdapter(result);
        });
    }

    public software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse describeStreamWithFilter(String streamArn, ShardFilter shardFilter, String consumerId) {
        DescribeStreamResponse describeStreamResponse;
        software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest describeStreamRequest = (software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest)DynamoDBStreamsRequestsBuilder.describeStreamRequestBuilder(consumerId).streamArn(streamArn).shardFilter(shardFilter).build();
        try {
            describeStreamResponse = this.internalClient.describeStream(describeStreamRequest);
        }
        catch (AwsServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisDescribeStream(e);
        }
        return KinesisMapperUtil.convertDynamoDBDescribeStreamResponseToKinesisDescribeStreamResponse(describeStreamResponse);
    }

    public void setSkipRecordsBehavior(SkipRecordsBehavior skipRecordsBehavior) {
        if (skipRecordsBehavior == null) {
            throw new NullPointerException("skipRecordsBehavior cannot be null");
        }
        this.skipRecordsBehavior = skipRecordsBehavior;
    }

    private DescribeStreamResponse describeStreamWithRetries(software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest describeStreamRequest) {
        DescribeStreamResponse describeStreamResponse = null;
        int remainingRetries = 50;
        AwsServiceException lastException = null;
        while (describeStreamResponse == null) {
            block5: {
                try {
                    describeStreamResponse = this.internalClient.describeStream(describeStreamRequest);
                }
                catch (AwsServiceException e) {
                    if ("ThrottlingException".equals(e.awsErrorDetails().errorCode())) {
                        log.debug("Got LimitExceededException from DescribeStream, retrying {} times", (Object)remainingRetries);
                        this.sleeper.sleep(DESCRIBE_STREAM_CALLS_DELAY.toMillis());
                        lastException = e;
                    }
                    if (!(e instanceof ResourceNotFoundException)) break block5;
                    throw e;
                }
            }
            if (--remainingRetries != 0 || describeStreamResponse != null) continue;
            if (lastException != null) {
                throw lastException;
            }
            throw new IllegalStateException("Received null from DescribeStream call.");
        }
        return describeStreamResponse;
    }

    public SkipRecordsBehavior getSkipRecordsBehavior() {
        return this.skipRecordsBehavior;
    }

    public static enum SkipRecordsBehavior {
        SKIP_RECORDS_TO_TRIM_HORIZON,
        KCL_RETRY;

    }
}

