/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.util;

import com.amazonaws.services.dynamodbv2.streamsadapter.serialization.RecordObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;
import software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.StreamDescription;

public final class KinesisMapperUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KinesisMapperUtil.class);
    private static final Pattern DYNAMODB_STREAM_ARN_PATTERN = Pattern.compile("arn:aws[^:]*:dynamodb:(?<region>[-a-z0-9]+):(?<accountId>[0-9]{12}):table/(?<tableName>[^/]+)/stream/(?<streamLabel>.+)");
    private static final String DELIMITER = "$";
    private static final String COLON_REPLACEMENT = "_";
    private static final ObjectMapper MAPPER = new RecordObjectMapper();
    private static final String SHARD_ID_SEPARATOR = "-";
    public static final Duration MIN_LEASE_RETENTION_DURATION_IN_HOURS = Duration.ofHours(6L);
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    private KinesisMapperUtil() {
    }

    public static Shard convertDynamoDBShardToKinesisShard(software.amazon.awssdk.services.dynamodb.model.Shard dynamoDBShard) {
        return (Shard)Shard.builder().shardId(dynamoDBShard.shardId()).parentShardId(dynamoDBShard.parentShardId()).adjacentParentShardId(null).sequenceNumberRange((SequenceNumberRange)SequenceNumberRange.builder().startingSequenceNumber(dynamoDBShard.sequenceNumberRange().startingSequenceNumber()).endingSequenceNumber(dynamoDBShard.sequenceNumberRange().endingSequenceNumber()).build()).hashKeyRange((HashKeyRange)HashKeyRange.builder().startingHashKey(BigInteger.ZERO.toString()).endingHashKey(BigInteger.ONE.toString()).build()).build();
    }

    public static software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse convertDynamoDBGetShardIteratorResponseToKinesisGetShardIteratorResponse(GetShardIteratorResponse dynamoDBGetShardIteratorResponse) {
        return (software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse)software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse.builder().shardIterator(dynamoDBGetShardIteratorResponse.shardIterator()).build();
    }

    public static software.amazon.awssdk.services.kinesis.model.ListStreamsResponse convertDynamoDBListStreamsResponseToKinesisListStreamsResponse(ListStreamsResponse listStreamsResponse) {
        return (software.amazon.awssdk.services.kinesis.model.ListStreamsResponse)software.amazon.awssdk.services.kinesis.model.ListStreamsResponse.builder().streamNames((Collection)listStreamsResponse.streams().stream().map(Stream::streamArn).collect(Collectors.toList())).hasMoreStreams(Boolean.valueOf(listStreamsResponse.lastEvaluatedStreamArn() != null)).build();
    }

    public static software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse convertDynamoDBDescribeStreamResponseToKinesisDescribeStreamResponse(DescribeStreamResponse describeStreamResponse) {
        return (software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse)software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse.builder().streamDescription((StreamDescription)StreamDescription.builder().streamName(describeStreamResponse.streamDescription().streamArn()).shards((Collection)describeStreamResponse.streamDescription().shards().stream().map(KinesisMapperUtil::convertDynamoDBShardToKinesisShard).collect(Collectors.toList())).streamStatus(describeStreamResponse.streamDescription().streamStatus().toString()).hasMoreShards(Boolean.valueOf(describeStreamResponse.streamDescription().lastEvaluatedShardId() != null)).build()).build();
    }

    public static Instant getShardCreationTime(String shardId) {
        return Instant.ofEpochMilli(Long.parseLong(shardId.split(SHARD_ID_SEPARATOR)[1]));
    }

    public static boolean isValidDynamoDBStreamArn(String arn) {
        if (arn == null) {
            return false;
        }
        return DYNAMODB_STREAM_ARN_PATTERN.matcher(arn).matches();
    }

    public static String createKinesisStreamIdentifierFromDynamoDBStreamsArn(String dynamoDbStreamArn, boolean isMultiStreamMode) {
        Matcher matcher = DYNAMODB_STREAM_ARN_PATTERN.matcher(dynamoDbStreamArn);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid DynamoDB stream ARN format: " + dynamoDbStreamArn);
        }
        String region = matcher.group("region");
        String accountId = matcher.group("accountId");
        String tableName = matcher.group("tableName");
        String streamLabel = matcher.group("streamLabel").replace(":", COLON_REPLACEMENT);
        String kinesisStreamName = String.join((CharSequence)DELIMITER, region, accountId, tableName, streamLabel);
        if (isMultiStreamMode) {
            return String.join((CharSequence)":", accountId, kinesisStreamName, "1");
        }
        return kinesisStreamName;
    }

    public static String createDynamoDBStreamsArnFromKinesisStreamName(String streamName) {
        String streamLabel;
        String tableName;
        String accountId;
        boolean isMultiStreamMode = streamName.contains(":");
        String streamNameToUse = isMultiStreamMode ? streamName.split(":")[1] : streamName;
        String[] parts = streamNameToUse.split(Pattern.quote(DELIMITER));
        String region = parts[0];
        String dynamoDBStreamArn = String.format("arn:aws:dynamodb:%s:%s:table/%s/stream/%s", region, accountId = parts[1], tableName = parts[2], streamLabel = parts[3].replace(COLON_REPLACEMENT, ":"));
        if (!KinesisMapperUtil.isValidDynamoDBStreamArn(dynamoDBStreamArn)) {
            throw new IllegalArgumentException("Invalid DynamoDB stream ARN: " + dynamoDBStreamArn);
        }
        return dynamoDBStreamArn;
    }
}

