/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.util;

import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.exceptions.UnableToReadMoreRecordsException;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;

public final class AmazonServiceExceptionTransformer {
    private static final String TRIMMED_DATA_KCL_RETRY_MESSAGE = "Attempted to get a shard iterator for a trimmed shard. Data has been lost";
    public static final String DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE = "ThrottlingException";
    public static final String EMPTY_STRING = "";
    public static final String KINESIS_INTERNAL_ERROR_MESSAGE = "InternalFailure";
    public static final String KINESIS_VALIDATION_ERROR_MESSAGE = "ValidationError";
    private static final Log LOG = LogFactory.getLog(AmazonServiceExceptionTransformer.class);

    private AmazonServiceExceptionTransformer() {
    }

    private static AwsServiceException applyFields(AwsServiceException original, AwsServiceException.Builder transforming) {
        if (transforming == null) {
            LOG.error((Object)"Could not transform a DynamoDB AmazonServiceException to a compatible Kinesis exception", (Throwable)original);
            return original;
        }
        AwsErrorDetails.Builder transformingDetailsBuilder = AmazonServiceExceptionTransformer.getDetailsBuilder(transforming.awsErrorDetails());
        if (original.awsErrorDetails() != null && original.awsErrorDetails().errorCode() != null) {
            transformingDetailsBuilder.errorCode(original.awsErrorDetails().errorCode());
        }
        if (original.awsErrorDetails() != null && original.awsErrorDetails().serviceName() != null) {
            transformingDetailsBuilder.serviceName(original.awsErrorDetails().serviceName());
        }
        transforming.awsErrorDetails(transformingDetailsBuilder.build());
        if (original.requestId() != null) {
            transforming.requestId(original.requestId());
        }
        transforming.statusCode(original.statusCode());
        LOG.debug((Object)String.format("DynamoDB Streams exception: %s tranformed to Kinesis %s", ((Object)((Object)original)).getClass(), transforming.getClass()), (Throwable)original);
        return transforming.build();
    }

    private static AwsErrorDetails.Builder getDetailsBuilder(@Nullable AwsErrorDetails aed) {
        return aed == null ? AwsErrorDetails.builder() : aed.toBuilder();
    }

    private static String buildErrorMessage(AwsServiceException ase) {
        if (ase.getMessage() == null) {
            return EMPTY_STRING;
        }
        return ase.getMessage();
    }

    public static AwsServiceException transformDynamoDBStreamsToKinesisDescribeStream(AwsServiceException ase) {
        if (ase == null) {
            return ase;
        }
        Object transforming = ase instanceof InternalServerErrorException ? AwsServiceException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)).cause((Throwable)ase) : (ase instanceof software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException ? ResourceNotFoundException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)) : (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.awsErrorDetails().errorCode()) ? software.amazon.awssdk.services.kinesis.model.LimitExceededException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)) : null));
        return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AwsServiceException transformDynamoDBStreamsToKinesisGetRecords(AwsServiceException ase, AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior skipRecordsBehavior) {
        ExpiredIteratorException.Builder transforming;
        if (ase == null) {
            return ase;
        }
        if (ase instanceof ExpiredIteratorException) {
            transforming = software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
        } else if (ase instanceof InternalServerErrorException) {
            transforming = AwsServiceException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)).cause((Throwable)ase);
            return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
        } else if (ase instanceof LimitExceededException) {
            transforming = ProvisionedThroughputExceededException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
        } else if (ase instanceof software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException) {
            transforming = ResourceNotFoundException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
        } else if (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.awsErrorDetails().errorCode())) {
            transforming = ProvisionedThroughputExceededException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
        } else if (ase instanceof TrimmedDataAccessException) {
            if (skipRecordsBehavior != AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) throw new UnableToReadMoreRecordsException("Attempted to access trimmed data. Data has been lost", ase);
            transforming = software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
        } else {
            transforming = null;
        }
        return AmazonServiceExceptionTransformer.applyFields(ase, (AwsServiceException.Builder)transforming);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AwsServiceException transformDynamoDBStreamsToKinesisGetShardIterator(AwsServiceException ase, AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior skipRecordsBehavior) {
        if (ase == null) {
            return ase;
        }
        AwsServiceException.Builder transforming = null;
        if (ase instanceof InternalServerErrorException) {
            transforming = AwsServiceException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)).cause((Throwable)ase);
            return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
        } else if (ase instanceof software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException) {
            if (skipRecordsBehavior != AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) throw new UnableToReadMoreRecordsException(TRIMMED_DATA_KCL_RETRY_MESSAGE, ase);
            transforming = ResourceNotFoundException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
        } else if (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.awsErrorDetails().errorCode())) {
            transforming = ProvisionedThroughputExceededException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
        } else {
            if (!(ase instanceof TrimmedDataAccessException)) return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
            if (skipRecordsBehavior != AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) throw new UnableToReadMoreRecordsException(TRIMMED_DATA_KCL_RETRY_MESSAGE, ase);
            transforming = ResourceNotFoundException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
        }
        return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
    }

    public static AwsServiceException transformDynamoDBStreamsToKinesisListStreams(AwsServiceException ase) {
        if (ase == null) {
            return ase;
        }
        Object transforming = ase instanceof InternalServerErrorException ? AwsServiceException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)).cause((Throwable)ase) : (ase instanceof software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException ? AwsServiceException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)).cause((Throwable)ase) : (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.awsErrorDetails().errorCode()) ? software.amazon.awssdk.services.kinesis.model.LimitExceededException.builder().message(AmazonServiceExceptionTransformer.buildErrorMessage(ase)) : null));
        return AmazonServiceExceptionTransformer.applyFields(ase, transforming);
    }
}

