/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.polling;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.polling.PollingConfig;
import software.amazon.kinesis.retrieval.polling.SynchronousBlockingRetrievalFactory;

public class DynamoDBStreamsPollingConfig
extends PollingConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamoDBStreamsPollingConfig.class);
    private long idleTimeBetweenReadsInMillis = 1000L;

    public DynamoDBStreamsPollingConfig(KinesisAsyncClient kinesisAsyncClient) {
        super(kinesisAsyncClient);
    }

    public DynamoDBStreamsPollingConfig(String streamName, KinesisAsyncClient kinesisAsyncClient) {
        super(streamName, kinesisAsyncClient);
    }

    public DynamoDBStreamsPollingConfig idleTimeBetweenReadsInMillis(long idleTimeBetweenReadsInMillis) {
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        return this;
    }

    public RetrievalFactory retrievalFactory() {
        this.recordsFetcherFactory().idleMillisBetweenCalls(this.idleTimeBetweenReadsInMillis);
        return new SynchronousBlockingRetrievalFactory(this.streamName(), this.kinesisClient(), this.recordsFetcherFactory(), this.maxRecords(), this.kinesisRequestTimeout(), this.dataFetcherProvider(), this.sleepTimeController());
    }

    @Generated
    public long idleTimeBetweenReadsInMillis() {
        return this.idleTimeBetweenReadsInMillis;
    }

    @Generated
    public String toString() {
        return "DynamoDBStreamsPollingConfig(idleTimeBetweenReadsInMillis=" + this.idleTimeBetweenReadsInMillis() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBStreamsPollingConfig)) {
            return false;
        }
        DynamoDBStreamsPollingConfig other = (DynamoDBStreamsPollingConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.idleTimeBetweenReadsInMillis() == other.idleTimeBetweenReadsInMillis();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBStreamsPollingConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $idleTimeBetweenReadsInMillis = this.idleTimeBetweenReadsInMillis();
        result = result * 59 + (int)($idleTimeBetweenReadsInMillis >>> 32 ^ $idleTimeBetweenReadsInMillis);
        return result;
    }
}

