/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.model;

import com.amazonaws.services.dynamodbv2.streamsadapter.adapter.DynamoDBStreamsClientRecord;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import software.amazon.awssdk.services.kinesis.model.ChildShard;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;

public class DynamoDBStreamsProcessRecordsInput {
    private Instant cacheEntryTime;
    private Instant cacheExitTime;
    private boolean isAtShardEnd;
    private List<DynamoDBStreamsClientRecord> records;
    private RecordProcessorCheckpointer checkpointer;
    private Long millisBehindLatest;
    private List<ChildShard> childShards;

    public Duration timeSpentInCache() {
        if (this.cacheEntryTime == null || this.cacheExitTime == null) {
            return Duration.ZERO;
        }
        return Duration.between(this.cacheEntryTime, this.cacheExitTime);
    }

    @Generated
    DynamoDBStreamsProcessRecordsInput(Instant cacheEntryTime, Instant cacheExitTime, boolean isAtShardEnd, List<DynamoDBStreamsClientRecord> records, RecordProcessorCheckpointer checkpointer, Long millisBehindLatest, List<ChildShard> childShards) {
        this.cacheEntryTime = cacheEntryTime;
        this.cacheExitTime = cacheExitTime;
        this.isAtShardEnd = isAtShardEnd;
        this.records = records;
        this.checkpointer = checkpointer;
        this.millisBehindLatest = millisBehindLatest;
        this.childShards = childShards;
    }

    @Generated
    public static DynamoDBStreamsProcessRecordsInputBuilder builder() {
        return new DynamoDBStreamsProcessRecordsInputBuilder();
    }

    @Generated
    public DynamoDBStreamsProcessRecordsInputBuilder toBuilder() {
        return new DynamoDBStreamsProcessRecordsInputBuilder().cacheEntryTime(this.cacheEntryTime).cacheExitTime(this.cacheExitTime).isAtShardEnd(this.isAtShardEnd).records(this.records).checkpointer(this.checkpointer).millisBehindLatest(this.millisBehindLatest).childShards(this.childShards);
    }

    @Generated
    public Instant cacheEntryTime() {
        return this.cacheEntryTime;
    }

    @Generated
    public Instant cacheExitTime() {
        return this.cacheExitTime;
    }

    @Generated
    public boolean isAtShardEnd() {
        return this.isAtShardEnd;
    }

    @Generated
    public List<DynamoDBStreamsClientRecord> records() {
        return this.records;
    }

    @Generated
    public RecordProcessorCheckpointer checkpointer() {
        return this.checkpointer;
    }

    @Generated
    public Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    @Generated
    public List<ChildShard> childShards() {
        return this.childShards;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBStreamsProcessRecordsInput)) {
            return false;
        }
        DynamoDBStreamsProcessRecordsInput other = (DynamoDBStreamsProcessRecordsInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAtShardEnd() != other.isAtShardEnd()) {
            return false;
        }
        Long this$millisBehindLatest = this.millisBehindLatest();
        Long other$millisBehindLatest = other.millisBehindLatest();
        if (this$millisBehindLatest == null ? other$millisBehindLatest != null : !((Object)this$millisBehindLatest).equals(other$millisBehindLatest)) {
            return false;
        }
        Instant this$cacheEntryTime = this.cacheEntryTime();
        Instant other$cacheEntryTime = other.cacheEntryTime();
        if (this$cacheEntryTime == null ? other$cacheEntryTime != null : !((Object)this$cacheEntryTime).equals(other$cacheEntryTime)) {
            return false;
        }
        Instant this$cacheExitTime = this.cacheExitTime();
        Instant other$cacheExitTime = other.cacheExitTime();
        if (this$cacheExitTime == null ? other$cacheExitTime != null : !((Object)this$cacheExitTime).equals(other$cacheExitTime)) {
            return false;
        }
        List<DynamoDBStreamsClientRecord> this$records = this.records();
        List<DynamoDBStreamsClientRecord> other$records = other.records();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        RecordProcessorCheckpointer this$checkpointer = this.checkpointer();
        RecordProcessorCheckpointer other$checkpointer = other.checkpointer();
        if (this$checkpointer == null ? other$checkpointer != null : !this$checkpointer.equals(other$checkpointer)) {
            return false;
        }
        List<ChildShard> this$childShards = this.childShards();
        List<ChildShard> other$childShards = other.childShards();
        return !(this$childShards == null ? other$childShards != null : !((Object)this$childShards).equals(other$childShards));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBStreamsProcessRecordsInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAtShardEnd() ? 79 : 97);
        Long $millisBehindLatest = this.millisBehindLatest();
        result = result * 59 + ($millisBehindLatest == null ? 43 : ((Object)$millisBehindLatest).hashCode());
        Instant $cacheEntryTime = this.cacheEntryTime();
        result = result * 59 + ($cacheEntryTime == null ? 43 : ((Object)$cacheEntryTime).hashCode());
        Instant $cacheExitTime = this.cacheExitTime();
        result = result * 59 + ($cacheExitTime == null ? 43 : ((Object)$cacheExitTime).hashCode());
        List<DynamoDBStreamsClientRecord> $records = this.records();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        RecordProcessorCheckpointer $checkpointer = this.checkpointer();
        result = result * 59 + ($checkpointer == null ? 43 : $checkpointer.hashCode());
        List<ChildShard> $childShards = this.childShards();
        result = result * 59 + ($childShards == null ? 43 : ((Object)$childShards).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamoDBStreamsProcessRecordsInput(cacheEntryTime=" + this.cacheEntryTime() + ", cacheExitTime=" + this.cacheExitTime() + ", isAtShardEnd=" + this.isAtShardEnd() + ", records=" + this.records() + ", checkpointer=" + this.checkpointer() + ", millisBehindLatest=" + this.millisBehindLatest() + ", childShards=" + this.childShards() + ")";
    }

    @Generated
    public static class DynamoDBStreamsProcessRecordsInputBuilder {
        @Generated
        private Instant cacheEntryTime;
        @Generated
        private Instant cacheExitTime;
        @Generated
        private boolean isAtShardEnd;
        @Generated
        private List<DynamoDBStreamsClientRecord> records;
        @Generated
        private RecordProcessorCheckpointer checkpointer;
        @Generated
        private Long millisBehindLatest;
        @Generated
        private List<ChildShard> childShards;

        @Generated
        DynamoDBStreamsProcessRecordsInputBuilder() {
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder cacheEntryTime(Instant cacheEntryTime) {
            this.cacheEntryTime = cacheEntryTime;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder cacheExitTime(Instant cacheExitTime) {
            this.cacheExitTime = cacheExitTime;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder isAtShardEnd(boolean isAtShardEnd) {
            this.isAtShardEnd = isAtShardEnd;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder records(List<DynamoDBStreamsClientRecord> records) {
            this.records = records;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder checkpointer(RecordProcessorCheckpointer checkpointer) {
            this.checkpointer = checkpointer;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInputBuilder childShards(List<ChildShard> childShards) {
            this.childShards = childShards;
            return this;
        }

        @Generated
        public DynamoDBStreamsProcessRecordsInput build() {
            return new DynamoDBStreamsProcessRecordsInput(this.cacheEntryTime, this.cacheExitTime, this.isAtShardEnd, this.records, this.checkpointer, this.millisBehindLatest, this.childShards);
        }

        @Generated
        public String toString() {
            return "DynamoDBStreamsProcessRecordsInput.DynamoDBStreamsProcessRecordsInputBuilder(cacheEntryTime=" + this.cacheEntryTime + ", cacheExitTime=" + this.cacheExitTime + ", isAtShardEnd=" + this.isAtShardEnd + ", records=" + this.records + ", checkpointer=" + this.checkpointer + ", millisBehindLatest=" + this.millisBehindLatest + ", childShards=" + this.childShards + ")";
        }
    }
}

