/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import java.time.Duration;
import java.time.Instant;
import software.amazon.kinesis.retrieval.polling.SleepTimeController;
import software.amazon.kinesis.retrieval.polling.SleepTimeControllerConfig;

public class DynamoDBStreamsSleepTimeController
implements SleepTimeController {
    public long getSleepTimeMillis(SleepTimeControllerConfig sleepTimeControllerConfig) {
        long idleMillsBetweenCalls = sleepTimeControllerConfig.idleMillisBetweenCalls();
        Instant lastSuccessfulCall = sleepTimeControllerConfig.lastSuccessfulCall();
        Integer lastGetRecordsReturnedRecordsCount = sleepTimeControllerConfig.lastRecordsCount();
        if (lastSuccessfulCall == null || lastGetRecordsReturnedRecordsCount == null) {
            return idleMillsBetweenCalls;
        }
        long sleepTime = lastGetRecordsReturnedRecordsCount > 0 ? idleMillsBetweenCalls : 2L * idleMillsBetweenCalls;
        long timeSinceLastCall = Duration.between(lastSuccessfulCall, Instant.now()).abs().toMillis();
        if (timeSinceLastCall < sleepTime) {
            return sleepTime - timeSinceLastCall;
        }
        return 0L;
    }
}

