/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import java.util.concurrent.ExecutorService;

public class StreamsWorkerFactory {
    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)new AmazonDynamoDBStreamsAdapterClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration())).execService(execService).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).execService(execService).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).execService(execService).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).execService(execService).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).metricsFactory(metricsFactory).execService(execService).build();
    }
}

