/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.LockItem;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class SendHeartbeatOptions {
    private final LockItem lockItem;
    private final Optional<ByteBuffer> data;
    private final Boolean deleteData;
    private final Long leaseDurationToEnsure;
    private final TimeUnit timeUnit;

    private SendHeartbeatOptions(LockItem lockItem, Optional<ByteBuffer> data, Boolean deleteData, Long leaseDurationToEnsure, TimeUnit timeUnit) {
        this.lockItem = lockItem;
        this.data = data;
        this.deleteData = deleteData;
        this.leaseDurationToEnsure = leaseDurationToEnsure;
        this.timeUnit = timeUnit;
    }

    public static SendHeartbeatOptionsBuilder builder(LockItem lockItem) {
        return new SendHeartbeatOptionsBuilder(lockItem);
    }

    LockItem getLockItem() {
        return this.lockItem;
    }

    Optional<ByteBuffer> getData() {
        return this.data;
    }

    Boolean getDeleteData() {
        return this.deleteData;
    }

    Long getLeaseDurationToEnsure() {
        return this.leaseDurationToEnsure;
    }

    TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public static class SendHeartbeatOptionsBuilder {
        private LockItem lockItem;
        private Optional<ByteBuffer> data;
        private Boolean deleteData;
        private Long leaseDurationToEnsure;
        private TimeUnit timeUnit;

        SendHeartbeatOptionsBuilder(LockItem lockItem) {
            this.lockItem = lockItem;
            this.data = Optional.empty();
        }

        public SendHeartbeatOptionsBuilder withData(ByteBuffer data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public SendHeartbeatOptionsBuilder withDeleteData(Boolean deleteData) {
            this.deleteData = deleteData;
            return this;
        }

        public SendHeartbeatOptionsBuilder withLeaseDurationToEnsure(Long leaseDurationToEnsure) {
            this.leaseDurationToEnsure = leaseDurationToEnsure;
            return this;
        }

        public SendHeartbeatOptionsBuilder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public SendHeartbeatOptions build() {
            return new SendHeartbeatOptions(this.lockItem, this.data, this.deleteData, this.leaseDurationToEnsure, this.timeUnit);
        }

        public String toString() {
            return "SendHeartbeatOptions.SendHeartbeatOptionsBuilder(lockItem=" + this.lockItem + ", data=" + this.data + ", deleteData=" + this.deleteData + ", leaseDurationToEnsure=" + this.leaseDurationToEnsure + ", timeUnit=" + (Object)((Object)this.timeUnit) + ")";
        }
    }
}

