/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ConnectionInfo {
    private final @Nullable String sanitizedUrl;
    private final @Nullable String user;
    private final @Nullable String host;
    private final @Nullable String dbName;

    private ConnectionInfo(@Nullable String sanitizedUrl, @Nullable String user, @Nullable String host, @Nullable String dbName) {
        this.sanitizedUrl = sanitizedUrl;
        this.user = user;
        this.host = host;
        this.dbName = dbName;
    }

    String getSanitizedUrl() {
        return this.sanitizedUrl;
    }

    String getUser() {
        return this.user;
    }

    String getHost() {
        return this.host;
    }

    String getDbName() {
        return this.dbName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        return Objects.equals(this.sanitizedUrl, that.sanitizedUrl) && Objects.equals(this.user, that.user) && Objects.equals(this.host, that.host) && Objects.equals(this.dbName, that.dbName);
    }

    public int hashCode() {
        int result = this.sanitizedUrl != null ? this.sanitizedUrl.hashCode() : 0;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (this.dbName != null ? this.dbName.hashCode() : 0);
        return result;
    }

    static class Builder {
        private String sanitizedUrl;
        private String user;
        private String host;
        private String dbName;

        Builder() {
        }

        Builder sanitizedUrl(String sanitizedUrl) {
            this.sanitizedUrl = sanitizedUrl;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder host(String host) {
            this.host = host;
            return this;
        }

        Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        ConnectionInfo build() {
            return new ConnectionInfo(this.sanitizedUrl, this.user, this.host, this.dbName);
        }
    }
}

