/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql.postgres;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.JdbcInterceptor;
import org.apache.tomcat.jdbc.pool.PooledConnection;

public class TracingInterceptor
extends JdbcInterceptor {
    protected static final String CREATE_STATEMENT = "createStatement";
    protected static final int CREATE_STATEMENT_INDEX = 0;
    protected static final String PREPARE_STATEMENT = "prepareStatement";
    protected static final int PREPARE_STATEMENT_INDEX = 1;
    protected static final String PREPARE_CALL = "prepareCall";
    protected static final int PREPARE_CALL_INDEX = 2;
    protected static final String[] STATEMENT_TYPES = new String[]{"createStatement", "prepareStatement", "prepareCall"};
    protected static final int STATEMENT_TYPE_COUNT = STATEMENT_TYPES.length;
    protected static final String EXECUTE = "execute";
    protected static final String EXECUTE_QUERY = "executeQuery";
    protected static final String EXECUTE_UPDATE = "executeUpdate";
    protected static final String EXECUTE_BATCH = "executeBatch";
    protected static final String[] EXECUTE_TYPES = new String[]{"execute", "executeQuery", "executeUpdate", "executeBatch"};
    private static final Log logger = LogFactory.getLog(TracingInterceptor.class);
    protected static final Constructor<?>[] constructors = new Constructor[STATEMENT_TYPE_COUNT];
    private static final String DEFAULT_DATABASE_NAME = "database";

    protected Constructor<?> getConstructor(int index, Class<?> clazz) throws NoSuchMethodException {
        if (constructors[index] == null) {
            Class<?> proxyClass = Proxy.getProxyClass(TracingInterceptor.class.getClassLoader(), clazz);
            TracingInterceptor.constructors[index] = proxyClass.getConstructor(InvocationHandler.class);
        }
        return constructors[index];
    }

    public Object createStatement(Object proxy, Method method, Object[] args, Object statementObject) {
        try {
            Object result = null;
            String name = method.getName();
            String sql = null;
            Constructor<?> constructor = null;
            HashMap<String, Object> additionalParams = new HashMap<String, Object>();
            if (this.compare(CREATE_STATEMENT, name)) {
                constructor = this.getConstructor(0, Statement.class);
            } else if (this.compare(PREPARE_STATEMENT, name)) {
                additionalParams.put("preparation", "statement");
                sql = (String)args[0];
                constructor = this.getConstructor(1, PreparedStatement.class);
            } else if (this.compare(PREPARE_CALL, name)) {
                additionalParams.put("preparation", "call");
                sql = (String)args[0];
                constructor = this.getConstructor(2, CallableStatement.class);
            } else {
                return statementObject;
            }
            Statement statement = (Statement)statementObject;
            Connection connection = statement.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            additionalParams.put("url", metadata.getURL());
            additionalParams.put("user", metadata.getUserName());
            additionalParams.put("driver_version", metadata.getDriverVersion());
            additionalParams.put("database_type", metadata.getDatabaseProductName());
            additionalParams.put("database_version", metadata.getDatabaseProductVersion());
            String hostname = DEFAULT_DATABASE_NAME;
            try {
                URI normalizedURI = new URI(new URI(metadata.getURL()).getSchemeSpecificPart());
                hostname = connection.getCatalog() + "@" + normalizedURI.getHost();
            }
            catch (URISyntaxException e) {
                logger.warn((Object)"Unable to parse database URI. Falling back to default 'database' for subsegment name.", (Throwable)e);
            }
            logger.debug((Object)"Instantiating new statement proxy.");
            result = constructor.newInstance(new TracingStatementProxy(statementObject, sql, hostname, additionalParams));
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            logger.warn((Object)"Unable to create statement proxy for tracing.", (Throwable)e);
            return statementObject;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.compare("close", method)) {
            return super.invoke(proxy, method, args);
        }
        boolean process = this.isStatement(method);
        if (process) {
            Object statement = super.invoke(proxy, method, args);
            return this.createStatement(proxy, method, args, statement);
        }
        return super.invoke(proxy, method, args);
    }

    private boolean isStatement(Method method) {
        return this.isMemberOf(STATEMENT_TYPES, method);
    }

    private boolean isExecute(Method method) {
        return this.isMemberOf(EXECUTE_TYPES, method);
    }

    protected boolean isMemberOf(String[] names, Method method) {
        boolean member = false;
        String name = method.getName();
        for (int i = 0; !member && i < names.length; ++i) {
            member = this.compare(names[i], name);
        }
        return member;
    }

    public void reset(ConnectionPool parent, PooledConnection con) {
    }

    protected class TracingStatementProxy
    implements InvocationHandler {
        protected boolean closed = false;
        protected Object delegate;
        protected final String query;
        protected final String hostname;
        protected Map<String, Object> additionalParams;

        public TracingStatementProxy(Object parent, String query, String hostname, Map<String, Object> additionalParams) {
            this.delegate = parent;
            this.query = query;
            this.hostname = hostname;
            this.additionalParams = additionalParams;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            boolean close = TracingInterceptor.this.compare("close", name);
            if (close && this.closed) {
                return null;
            }
            if (TracingInterceptor.this.compare("isClosed", name)) {
                return this.closed;
            }
            if (this.closed) {
                throw new SQLException("Statement closed.");
            }
            boolean process = TracingInterceptor.this.isExecute(method);
            Object result = null;
            Subsegment subsegment = null;
            if (process) {
                subsegment = AWSXRay.beginSubsegment((String)this.hostname);
            }
            try {
                if (process && null != subsegment) {
                    subsegment.putAllSql(this.additionalParams);
                    subsegment.setNamespace(Namespace.REMOTE.toString());
                }
                result = method.invoke(this.delegate, args);
            }
            catch (Throwable t) {
                if (null != subsegment) {
                    subsegment.addException(t);
                }
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    throw t.getCause();
                }
                throw t;
            }
            finally {
                if (process && null != subsegment) {
                    AWSXRay.endSubsegment();
                }
            }
            if (close) {
                this.closed = true;
                this.delegate = null;
            }
            return result;
        }
    }
}

