/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.spring.aop;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.spring.aop.XRayInterceptorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Configurable;

@Aspect
@Configurable
public class XRaySpringDataInterceptor {
    private static final Log logger = LogFactory.getLog(XRaySpringDataInterceptor.class);

    @Around(value="queryExecution()")
    public Object traceSQL(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Subsegment subsegment = AWSXRay.beginSubsegment((String)pjp.getSignature().getName());
            XRayInterceptorUtils.generateMetadata(pjp, subsegment);
            Object object = XRayInterceptorUtils.conditionalProceed(pjp);
            return object;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            AWSXRay.getCurrentSegment().addException((Throwable)e);
            throw e;
        }
        finally {
            logger.trace((Object)"Ending Subsegment");
            AWSXRay.endSubsegment();
        }
    }

    @Pointcut(value="execution(public !void java.sql.Statement.execute*(java.lang.String))")
    private void queryExecution() {
    }
}

