/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.spring.aop;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.exceptions.SegmentNotFoundException;
import com.amazonaws.xray.spring.aop.XRayEnabled;
import com.amazonaws.xray.spring.aop.XRayInterceptorUtils;
import com.amazonaws.xray.strategy.ContextMissingStrategy;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;

public abstract class AbstractXRayInterceptor {
    private static final Log logger = LogFactory.getLog(AbstractXRayInterceptor.class);

    private static ContextMissingStrategy getContextMissingStrategy() {
        return AWSXRay.getGlobalRecorder().getContextMissingStrategy();
    }

    private static Segment getCurrentSegment() {
        Optional segment = AWSXRay.getCurrentSegmentOptional();
        if (segment.isPresent()) {
            return (Segment)segment.get();
        }
        ContextMissingStrategy contextMissingStrategy = AbstractXRayInterceptor.getContextMissingStrategy();
        contextMissingStrategy.contextMissing("No segment in progress.", SegmentNotFoundException.class);
        return null;
    }

    @Around(value="xrayTracedClasses() || xrayEnabledClasses()")
    public Object traceAroundMethods(ProceedingJoinPoint pjp) throws Throwable {
        return this.processXRayTrace(pjp);
    }

    protected Object processXRayTrace(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Subsegment subsegment = AWSXRay.beginSubsegment((String)pjp.getSignature().getName());
            subsegment.setMetadata(this.generateMetadata(pjp, subsegment));
            Object object = XRayInterceptorUtils.conditionalProceed(pjp);
            return object;
        }
        catch (Exception e) {
            AWSXRay.getCurrentSegment().addException((Throwable)e);
            throw e;
        }
        finally {
            logger.trace((Object)"Ending Subsegment");
            AWSXRay.endSubsegment();
        }
    }

    protected abstract void xrayEnabledClasses();

    @Pointcut(value="execution(* XRayTraced+.*(..))")
    protected void xrayTracedClasses() {
    }

    @Pointcut(value="execution(public !void org.springframework.data.repository.Repository+.*(..))")
    protected void springRepositories() {
    }

    @Around(value="springRepositories()")
    public Object traceAroundRepositoryMethods(ProceedingJoinPoint pjp) throws Throwable {
        logger.trace((Object)"Advising repository");
        boolean hasClassAnnotation = false;
        for (Class<?> i : pjp.getTarget().getClass().getInterfaces()) {
            if (i.getAnnotation(XRayEnabled.class) == null) continue;
            hasClassAnnotation = true;
            break;
        }
        if (hasClassAnnotation) {
            return this.processXRayTrace(pjp);
        }
        return XRayInterceptorUtils.conditionalProceed(pjp);
    }

    protected Map<String, Map<String, Object>> generateMetadata(ProceedingJoinPoint pjp, Subsegment subsegment) {
        return XRayInterceptorUtils.generateMetadata(pjp, subsegment);
    }
}

