/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.slf4j;

import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.listeners.SegmentListener;
import org.slf4j.MDC;

public class SLF4JSegmentListener
implements SegmentListener {
    private static final String TRACE_ID_KEY = "AWS-XRAY-TRACE-ID";

    public void onBeginSegment(Segment segment) {
        if (segment != null) {
            MDC.put((String)TRACE_ID_KEY, (String)("AWS-XRAY-TRACE-ID: " + segment.getTraceId().toString()));
        }
    }

    public void beforeEndSegment(Segment segment) {
        MDC.remove((String)TRACE_ID_KEY);
    }
}

