/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.config;

import com.amazonaws.xray.entities.StringValidator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsDaemonConfiguration {
    private static final Log logger = LogFactory.getLog(MetricsDaemonConfiguration.class);
    private static final int DEFAULT_PORT = 25888;
    private InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 25888);
    public static final String DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY = "AWS_XRAY_METRICS_DAEMON_ADDRESS";
    public static final String DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY = "com.amazonaws.xray.metrics.daemonAddress";

    public MetricsDaemonConfiguration() {
        String environmentAddress = System.getenv(DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY);
        String systemAddress = System.getProperty(DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY);
        if (this.setUDPAddress(environmentAddress)) {
            logger.info((Object)String.format("Environment variable %s is set. Emitting to daemon on address %s.", DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY, this.getUDPAddress()));
        } else if (this.setUDPAddress(systemAddress)) {
            logger.info((Object)String.format("System property %s is set. Emitting to daemon on address %s.", DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY, this.getUDPAddress()));
        }
    }

    public void setDaemonAddress(String socketAddress) {
        String environmentAddress = System.getenv(DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY);
        String systemAddress = System.getProperty(DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY);
        if (StringValidator.isNullOrBlank((String)environmentAddress) && StringValidator.isNullOrBlank((String)systemAddress)) {
            this.setUDPAddress(socketAddress);
        } else {
            logger.info((Object)String.format("Ignoring call to setDaemonAddress as one of %s or %s is set.", DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY, DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY));
        }
    }

    public boolean setUDPAddress(String addr) {
        if (addr == null) {
            return false;
        }
        int lastColonIndex = addr.lastIndexOf(58);
        if (-1 == lastColonIndex) {
            logger.error((Object)("Invalid value for agent address: " + addr + ". Value must be of form \"ip_address:port\"."));
            return false;
        }
        String[] parts = addr.split(":");
        if (parts.length != 2) {
            logger.error((Object)("Invalid value for agent address: " + addr + ". Value must be of form \"ip_address:port\"."));
            return false;
        }
        this.address = new InetSocketAddress(addr.substring(0, lastColonIndex), Integer.parseInt(addr.substring(lastColonIndex + 1, addr.length())));
        logger.debug((Object)("UDPAddress is set to " + addr + "."));
        return true;
    }

    public String getUDPAddress() {
        return this.address.getHostString() + ":" + String.valueOf(this.address.getPort());
    }

    public InetSocketAddress getAddressForEmitter() {
        return this.address;
    }
}

