/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.metrics;

import com.amazonaws.xray.entities.FacadeSegment;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.listeners.SegmentListener;
import com.amazonaws.xray.metrics.MetricEmitter;
import com.amazonaws.xray.metrics.NoOpMetricEmitter;
import com.amazonaws.xray.metrics.UDPMetricEmitter;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsSegmentListener
implements SegmentListener {
    private static final Log logger = LogFactory.getLog(MetricsSegmentListener.class);
    private static final String AWS_EXECUTION_ENV_NAME = "AWS_EXECUTION_ENV";
    private static final String AWS_LAMBDA_PREFIX = "AWS_Lambda_";
    private MetricEmitter emitter = new NoOpMetricEmitter();

    public MetricsSegmentListener() {
        String awsEnv = System.getenv(AWS_EXECUTION_ENV_NAME);
        try {
            if (awsEnv != null && awsEnv.contains(AWS_LAMBDA_PREFIX)) {
                logger.info((Object)"Metric emissions is not supported on Lambda.");
            } else {
                logger.info((Object)"Emitting metrics to the CloudWatch Agent.");
                this.emitter = new UDPMetricEmitter();
            }
        }
        catch (SocketException e) {
            logger.error((Object)"Unable to construct metrics emitter. No metrics will be published.", (Throwable)e);
        }
    }

    public void afterEndSegment(Segment segment) {
        if (segment != null && !(segment instanceof FacadeSegment)) {
            this.emitter.emitMetric(segment);
        }
    }
}

