/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.api.client.api.LambdaContext;
import com.amazonaws.services.lambda.runtime.api.client.logging.JsonLogFormatter;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogFiltering;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogFormatter;
import com.amazonaws.services.lambda.runtime.api.client.logging.TextLogFormatter;
import com.amazonaws.services.lambda.runtime.logging.LogFormat;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import java.nio.charset.StandardCharsets;

public abstract class AbstractLambdaLogger
implements LambdaLogger {
    protected final LogFormat logFormat;
    private final LogFiltering logFiltering;
    private final LogFormatter logFormatter;

    public AbstractLambdaLogger(LogLevel logLevel, LogFormat logFormat) {
        this.logFiltering = new LogFiltering(logLevel);
        this.logFormat = logFormat;
        this.logFormatter = logFormat == LogFormat.JSON ? new JsonLogFormatter() : new TextLogFormatter();
    }

    protected abstract void logMessage(byte[] var1, LogLevel var2);

    protected void logMessage(String message, LogLevel logLevel) {
        byte[] messageBytes = message == null ? null : message.getBytes(StandardCharsets.UTF_8);
        this.logMessage(messageBytes, logLevel);
    }

    public void log(String message, LogLevel logLevel) {
        if (this.logFiltering.isEnabled(logLevel)) {
            this.logMessage(this.logFormatter.format(message, logLevel), logLevel);
        }
    }

    public void log(byte[] message, LogLevel logLevel) {
        if (this.logFiltering.isEnabled(logLevel)) {
            this.logMessage(message, logLevel);
        }
    }

    public void log(String message) {
        this.log(message, LogLevel.UNDEFINED);
    }

    public void log(byte[] message) {
        this.log(message, LogLevel.UNDEFINED);
    }

    public void setLambdaContext(LambdaContext lambdaContext) {
        this.logFormatter.setLambdaContext(lambdaContext);
    }

    public LogFormat getLogFormat() {
        return this.logFormat;
    }
}

