/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.runtimeapi;

import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.NativeClient;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class JniHelper {
    private static final String NATIVE_LIB_PATH = "/tmp/.libaws-lambda-jni.so";
    private static final String NATIVE_CLIENT_JNI_PROPERTY = "com.amazonaws.services.lambda.runtime.api.client.runtimeapi.NativeClient.JNI";

    public static void load() {
        String jniLib = System.getProperty(NATIVE_CLIENT_JNI_PROPERTY);
        if (jniLib != null) {
            System.load(jniLib);
        } else {
            String[] libsToTry = new String[]{"libaws-lambda-jni.linux-x86_64.so", "libaws-lambda-jni.linux-aarch_64.so", "libaws-lambda-jni.linux_musl-x86_64.so", "libaws-lambda-jni.linux_musl-aarch_64.so"};
            JniHelper.unpackAndLoad(libsToTry, NativeClient.class);
        }
    }

    private static void unpackAndLoad(String[] libsToTry, Class clazz) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String libToTry : libsToTry) {
            try (InputStream inputStream = clazz.getResourceAsStream(Paths.get("/jni", libToTry).toString());){
                if (inputStream == null) {
                    throw new FileNotFoundException("Specified file not in the JAR: " + libToTry);
                }
                Files.copy(inputStream, Paths.get(NATIVE_LIB_PATH, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                System.load(NATIVE_LIB_PATH);
                return;
            }
            catch (Exception | UnsatisfiedLinkError e) {
                errorMessages.add(e.getMessage());
            }
        }
        for (int i = 0; i < libsToTry.length; ++i) {
            System.err.println("Failed to load the native runtime interface client library " + libsToTry[i] + ". Exception: " + (String)errorMessages.get(i));
        }
        System.exit(-1);
    }
}

