/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.log4j2;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import com.amazonaws.services.lambda.runtime.LambdaRuntimeInternal;
import com.amazonaws.services.lambda.runtime.log4j2.LambdaJsonFormat;
import com.amazonaws.services.lambda.runtime.log4j2.LambdaTextFormat;
import com.amazonaws.services.lambda.runtime.logging.LogFormat;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;

@Plugin(name="Lambda", category="Core", elementType="appender", printObject=true)
public class LambdaAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "Lambda";
    public static final String PLUGIN_CATEGORY = "Core";
    public static final String PLUGIN_TYPE = "appender";
    private LambdaLogger logger = LambdaRuntime.getLogger();
    private static LogFormat logFormat;
    private static final Map<Level, LogLevel> logLevelMapper;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private LambdaAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    private LogLevel toLambdaLogLevel(Level level) {
        return logLevelMapper.getOrDefault(level, LogLevel.UNDEFINED);
    }

    public void append(LogEvent event) {
        this.logger.log(this.getLayout().toByteArray(event), this.toLambdaLogLevel(event.getLevel()));
    }

    static {
        LambdaRuntimeInternal.setUseLog4jAppender((boolean)true);
        logFormat = LogFormat.TEXT;
        logLevelMapper = new HashMap<Level, LogLevel>(){
            {
                this.put(Level.TRACE, LogLevel.TRACE);
                this.put(Level.DEBUG, LogLevel.DEBUG);
                this.put(Level.INFO, LogLevel.INFO);
                this.put(Level.WARN, LogLevel.WARN);
                this.put(Level.ERROR, LogLevel.ERROR);
                this.put(Level.FATAL, LogLevel.FATAL);
            }
        };
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LambdaAppender> {
        @PluginAttribute(value="format", defaultString="TEXT")
        LogFormat logFormat;
        @PluginElement(value="LambdaTextFormat")
        private LambdaTextFormat lambdaTextFormat;
        @PluginElement(value="LambdaJsonFormat")
        private LambdaJsonFormat lambdaJsonFormat;

        public LambdaAppender build() {
            Layout layout = this.logFormat == LogFormat.TEXT ? (this.lambdaTextFormat != null ? this.lambdaTextFormat.getLayout() : super.getOrCreateLayout()) : (this.lambdaJsonFormat != null ? this.lambdaJsonFormat.getLayout() : super.getOrCreateLayout());
            return new LambdaAppender(super.getName(), super.getFilter(), layout, super.isIgnoreExceptions());
        }
    }
}

