/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import com.amazonaws.services.lambda.runtime.events.CognitoUserPoolEvent;
import java.util.Arrays;
import java.util.Map;

public class CognitoUserPoolMigrateUserEvent
extends CognitoUserPoolEvent {
    private Request request;
    private Response response;

    public CognitoUserPoolMigrateUserEvent(String version, String triggerSource, String region, String userPoolId, String userName, CognitoUserPoolEvent.CallerContext callerContext, Request request, Response response) {
        super(version, triggerSource, region, userPoolId, userName, callerContext);
        this.request = request;
        this.response = response;
    }

    public static CognitoUserPoolMigrateUserEventBuilder builder() {
        return new CognitoUserPoolMigrateUserEventBuilder();
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CognitoUserPoolMigrateUserEvent)) {
            return false;
        }
        CognitoUserPoolMigrateUserEvent other = (CognitoUserPoolMigrateUserEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Request this$request = this.getRequest();
        Request other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CognitoUserPoolMigrateUserEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Request $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        return result;
    }

    public CognitoUserPoolMigrateUserEvent() {
    }

    @Override
    public String toString() {
        return "CognitoUserPoolMigrateUserEvent(super=" + super.toString() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
    }

    public static class CognitoUserPoolMigrateUserEventBuilder {
        private String version;
        private String triggerSource;
        private String region;
        private String userPoolId;
        private String userName;
        private CognitoUserPoolEvent.CallerContext callerContext;
        private Request request;
        private Response response;

        CognitoUserPoolMigrateUserEventBuilder() {
        }

        public CognitoUserPoolMigrateUserEventBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withTriggerSource(String triggerSource) {
            this.triggerSource = triggerSource;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withRegion(String region) {
            this.region = region;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withCallerContext(CognitoUserPoolEvent.CallerContext callerContext) {
            this.callerContext = callerContext;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withRequest(Request request) {
            this.request = request;
            return this;
        }

        public CognitoUserPoolMigrateUserEventBuilder withResponse(Response response) {
            this.response = response;
            return this;
        }

        public CognitoUserPoolMigrateUserEvent build() {
            return new CognitoUserPoolMigrateUserEvent(this.version, this.triggerSource, this.region, this.userPoolId, this.userName, this.callerContext, this.request, this.response);
        }

        public String toString() {
            return "CognitoUserPoolMigrateUserEvent.CognitoUserPoolMigrateUserEventBuilder(version=" + this.version + ", triggerSource=" + this.triggerSource + ", region=" + this.region + ", userPoolId=" + this.userPoolId + ", userName=" + this.userName + ", callerContext=" + this.callerContext + ", request=" + this.request + ", response=" + this.response + ")";
        }
    }

    public static class Response {
        private Map<String, String> userAttributes;
        private String finalUserStatus;
        private String messageAction;
        private String[] desiredDeliveryMediums;
        private boolean forceAliasCreation;

        public static ResponseBuilder builder() {
            return new ResponseBuilder();
        }

        public Response(Map<String, String> userAttributes, String finalUserStatus, String messageAction, String[] desiredDeliveryMediums, boolean forceAliasCreation) {
            this.userAttributes = userAttributes;
            this.finalUserStatus = finalUserStatus;
            this.messageAction = messageAction;
            this.desiredDeliveryMediums = desiredDeliveryMediums;
            this.forceAliasCreation = forceAliasCreation;
        }

        public Map<String, String> getUserAttributes() {
            return this.userAttributes;
        }

        public String getFinalUserStatus() {
            return this.finalUserStatus;
        }

        public String getMessageAction() {
            return this.messageAction;
        }

        public String[] getDesiredDeliveryMediums() {
            return this.desiredDeliveryMediums;
        }

        public boolean getForceAliasCreation() {
            return this.forceAliasCreation;
        }

        public void setUserAttributes(Map<String, String> userAttributes) {
            this.userAttributes = userAttributes;
        }

        public void setFinalUserStatus(String finalUserStatus) {
            this.finalUserStatus = finalUserStatus;
        }

        public void setMessageAction(String messageAction) {
            this.messageAction = messageAction;
        }

        public void setDesiredDeliveryMediums(String[] desiredDeliveryMediums) {
            this.desiredDeliveryMediums = desiredDeliveryMediums;
        }

        public void setForceAliasCreation(boolean forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getForceAliasCreation() != other.getForceAliasCreation()) {
                return false;
            }
            Map<String, String> this$userAttributes = this.getUserAttributes();
            Map<String, String> other$userAttributes = other.getUserAttributes();
            if (this$userAttributes == null ? other$userAttributes != null : !((Object)this$userAttributes).equals(other$userAttributes)) {
                return false;
            }
            String this$finalUserStatus = this.getFinalUserStatus();
            String other$finalUserStatus = other.getFinalUserStatus();
            if (this$finalUserStatus == null ? other$finalUserStatus != null : !this$finalUserStatus.equals(other$finalUserStatus)) {
                return false;
            }
            String this$messageAction = this.getMessageAction();
            String other$messageAction = other.getMessageAction();
            if (this$messageAction == null ? other$messageAction != null : !this$messageAction.equals(other$messageAction)) {
                return false;
            }
            return Arrays.deepEquals(this.getDesiredDeliveryMediums(), other.getDesiredDeliveryMediums());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.getForceAliasCreation() ? 79 : 97);
            Map<String, String> $userAttributes = this.getUserAttributes();
            result = result * 59 + ($userAttributes == null ? 43 : ((Object)$userAttributes).hashCode());
            String $finalUserStatus = this.getFinalUserStatus();
            result = result * 59 + ($finalUserStatus == null ? 43 : $finalUserStatus.hashCode());
            String $messageAction = this.getMessageAction();
            result = result * 59 + ($messageAction == null ? 43 : $messageAction.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getDesiredDeliveryMediums());
            return result;
        }

        public String toString() {
            return "CognitoUserPoolMigrateUserEvent.Response(userAttributes=" + this.getUserAttributes() + ", finalUserStatus=" + this.getFinalUserStatus() + ", messageAction=" + this.getMessageAction() + ", desiredDeliveryMediums=" + Arrays.deepToString(this.getDesiredDeliveryMediums()) + ", forceAliasCreation=" + this.getForceAliasCreation() + ")";
        }

        public Response() {
        }

        public static class ResponseBuilder {
            private Map<String, String> userAttributes;
            private String finalUserStatus;
            private String messageAction;
            private String[] desiredDeliveryMediums;
            private boolean forceAliasCreation;

            ResponseBuilder() {
            }

            public ResponseBuilder withUserAttributes(Map<String, String> userAttributes) {
                this.userAttributes = userAttributes;
                return this;
            }

            public ResponseBuilder withFinalUserStatus(String finalUserStatus) {
                this.finalUserStatus = finalUserStatus;
                return this;
            }

            public ResponseBuilder withMessageAction(String messageAction) {
                this.messageAction = messageAction;
                return this;
            }

            public ResponseBuilder withDesiredDeliveryMediums(String[] desiredDeliveryMediums) {
                this.desiredDeliveryMediums = desiredDeliveryMediums;
                return this;
            }

            public ResponseBuilder withForceAliasCreation(boolean forceAliasCreation) {
                this.forceAliasCreation = forceAliasCreation;
                return this;
            }

            public Response build() {
                return new Response(this.userAttributes, this.finalUserStatus, this.messageAction, this.desiredDeliveryMediums, this.forceAliasCreation);
            }

            public String toString() {
                return "CognitoUserPoolMigrateUserEvent.Response.ResponseBuilder(userAttributes=" + this.userAttributes + ", finalUserStatus=" + this.finalUserStatus + ", messageAction=" + this.messageAction + ", desiredDeliveryMediums=" + Arrays.deepToString(this.desiredDeliveryMediums) + ", forceAliasCreation=" + this.forceAliasCreation + ")";
            }
        }
    }

    public static class Request
    extends CognitoUserPoolEvent.Request {
        private String userName;
        private String password;
        private Map<String, String> validationData;
        private Map<String, String> clientMetadata;

        public Request(Map<String, String> userAttributes, Map<String, String> validationData, Map<String, String> clientMetadata, String userName, String password) {
            super(userAttributes);
            this.validationData = validationData;
            this.clientMetadata = clientMetadata;
            this.userName = userName;
            this.password = password;
        }

        public static RequestBuilder builder() {
            return new RequestBuilder();
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Map<String, String> getValidationData() {
            return this.validationData;
        }

        public Map<String, String> getClientMetadata() {
            return this.clientMetadata;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setValidationData(Map<String, String> validationData) {
            this.validationData = validationData;
        }

        public void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = clientMetadata;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Map<String, String> this$validationData = this.getValidationData();
            Map<String, String> other$validationData = other.getValidationData();
            if (this$validationData == null ? other$validationData != null : !((Object)this$validationData).equals(other$validationData)) {
                return false;
            }
            Map<String, String> this$clientMetadata = this.getClientMetadata();
            Map<String, String> other$clientMetadata = other.getClientMetadata();
            return !(this$clientMetadata == null ? other$clientMetadata != null : !((Object)this$clientMetadata).equals(other$clientMetadata));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Map<String, String> $validationData = this.getValidationData();
            result = result * 59 + ($validationData == null ? 43 : ((Object)$validationData).hashCode());
            Map<String, String> $clientMetadata = this.getClientMetadata();
            result = result * 59 + ($clientMetadata == null ? 43 : ((Object)$clientMetadata).hashCode());
            return result;
        }

        public Request() {
        }

        @Override
        public String toString() {
            return "CognitoUserPoolMigrateUserEvent.Request(super=" + super.toString() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", validationData=" + this.getValidationData() + ", clientMetadata=" + this.getClientMetadata() + ")";
        }

        public static class RequestBuilder {
            private Map<String, String> userAttributes;
            private Map<String, String> validationData;
            private Map<String, String> clientMetadata;
            private String userName;
            private String password;

            RequestBuilder() {
            }

            public RequestBuilder withUserAttributes(Map<String, String> userAttributes) {
                this.userAttributes = userAttributes;
                return this;
            }

            public RequestBuilder withValidationData(Map<String, String> validationData) {
                this.validationData = validationData;
                return this;
            }

            public RequestBuilder withClientMetadata(Map<String, String> clientMetadata) {
                this.clientMetadata = clientMetadata;
                return this;
            }

            public RequestBuilder withUserName(String userName) {
                this.userName = userName;
                return this;
            }

            public RequestBuilder withPassword(String password) {
                this.password = password;
                return this;
            }

            public Request build() {
                return new Request(this.userAttributes, this.validationData, this.clientMetadata, this.userName, this.password);
            }

            public String toString() {
                return "CognitoUserPoolMigrateUserEvent.Request.RequestBuilder(userAttributes=" + this.userAttributes + ", validationData=" + this.validationData + ", clientMetadata=" + this.clientMetadata + ", userName=" + this.userName + ", password=" + this.password + ")";
            }
        }
    }
}

