/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.amazonaws.services.simpleworkflow.flow.annotations.Asynchronous;
import com.amazonaws.services.simpleworkflow.flow.annotations.NoWait;
import com.amazonaws.services.simpleworkflow.flow.annotations.Wait;
import com.amazonaws.services.simpleworkflow.flow.aspectj.AsynchronousAspectTask;
import com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class AsynchronousAspect {
    @Around(value="call(@com.amazonaws.services.simpleworkflow.flow.annotations.Asynchronous * *(..)) && @annotation(asynchronousAnnotation)")
    public Object makeAsynchronous(ProceedingJoinPoint pjp, Asynchronous asynchronousAnnotation) throws Throwable {
        Signature signature = pjp.getStaticPart().getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            int i = 0;
            Object[] methodArguments = pjp.getArgs();
            Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
            ArrayList<Promise> valueParams = new ArrayList<Promise>();
            for (Class parameterType : methodSignature.getParameterTypes()) {
                if ((AsynchronousAspect.isPromise(parameterType) || AsynchronousAspect.isPromiseArray(parameterType) || AsynchronousAspect.isCollection(parameterType) && AsynchronousAspect.hasWaitAnnotation(parameterAnnotations[i])) && !AsynchronousAspect.hasNoWaitAnnotation(parameterAnnotations[i])) {
                    Object param = methodArguments[i];
                    if (AsynchronousAspect.isPromise(parameterType)) {
                        valueParams.add((Promise)param);
                    } else if (AsynchronousAspect.isCollection(parameterType)) {
                        valueParams.add(new AndPromise((Collection)param));
                    } else {
                        valueParams.add(new AndPromise((Promise[])param));
                    }
                } else {
                    valueParams.add(null);
                }
                ++i;
            }
            Promise[] values = valueParams.toArray(new Promise[0]);
            Boolean daemon = asynchronousAnnotation.daemon() ? Boolean.valueOf(true) : null;
            AsynchronousAspectTask task = new AsynchronousAspectTask(daemon, pjp, values);
            return task.getReturnValue();
        }
        return pjp.proceed();
    }

    private static boolean isPromise(Class<?> clazz) {
        return Promise.class.isAssignableFrom(clazz);
    }

    private static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    private static boolean isPromiseArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> elementType = clazz.getComponentType();
        return AsynchronousAspect.isPromise(elementType);
    }

    private static boolean hasWaitAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(Wait.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNoWaitAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(NoWait.class)) continue;
            return true;
        }
        return false;
    }
}

