/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.glacier.internal.TreeHashInputStream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.util.BinaryUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class TreeHashGenerator {
    public static String calculateTreeHash(File file) throws AmazonClientException {
        try {
            return TreeHashGenerator.calculateTreeHash(new RepeatableFileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new AmazonClientException("Unable to compute hash for file: " + file.getAbsolutePath(), e);
        }
    }

    public static String calculateTreeHash(InputStream input) throws AmazonClientException {
        try {
            TreeHashInputStream treeHashInputStream = new TreeHashInputStream(input);
            byte[] buffer = new byte[1024];
            while (treeHashInputStream.read(buffer, 0, buffer.length) != -1) {
            }
            treeHashInputStream.close();
            return TreeHashGenerator.calculateTreeHash(treeHashInputStream.getChecksums());
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to compute hash", e);
        }
    }

    public static String calculateTreeHash(List<byte[]> checksums) throws AmazonClientException {
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        hashes.addAll(checksums);
        while (hashes.size() > 1) {
            ArrayList<Object> treeHashes = new ArrayList<Object>();
            for (int i = 0; i < hashes.size() / 2; ++i) {
                byte[] firstPart = (byte[])hashes.get(2 * i);
                byte[] secondPart = (byte[])hashes.get(2 * i + 1);
                byte[] concatenation = new byte[firstPart.length + secondPart.length];
                System.arraycopy(firstPart, 0, concatenation, 0, firstPart.length);
                System.arraycopy(secondPart, 0, concatenation, firstPart.length, secondPart.length);
                try {
                    treeHashes.add(TreeHashGenerator.computeSHA256Hash(concatenation));
                    continue;
                }
                catch (Exception e) {
                    throw new AmazonClientException("Unable to compute hash", e);
                }
            }
            if (hashes.size() % 2 == 1) {
                treeHashes.add(hashes.get(hashes.size() - 1));
            }
            hashes = treeHashes;
        }
        return BinaryUtils.toHex((byte[])hashes.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] computeSHA256Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(data));
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
    }
}

