/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateApplicationRequestMarshaller
implements Marshaller<Request<CreateApplicationRequest>, CreateApplicationRequest> {
    @Override
    public Request<CreateApplicationRequest> marshall(CreateApplicationRequest createApplicationRequest) {
        if (createApplicationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateApplicationRequest> request = new DefaultRequest<CreateApplicationRequest>(createApplicationRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplication");
        request.addParameter("Version", "2010-12-01");
        if (createApplicationRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createApplicationRequest.getApplicationName()));
        }
        if (createApplicationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createApplicationRequest.getDescription()));
        }
        return request;
    }
}

