/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;

public class BatchGetItemRequestMarshaller
implements Marshaller<Request<BatchGetItemRequest>, BatchGetItemRequest> {
    @Override
    public Request<BatchGetItemRequest> marshall(BatchGetItemRequest batchGetItemRequest) {
        if (batchGetItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetItemRequest> request = new DefaultRequest<BatchGetItemRequest>(batchGetItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchGetItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchGetItemRequest.getRequestItems() != null) {
                jsonWriter.key("RequestItems");
                jsonWriter.object();
                for (Map.Entry<String, KeysAndAttributes> requestItemsListValue : batchGetItemRequest.getRequestItems().entrySet()) {
                    ListWithAutoConstructFlag attributesToGetList;
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.key(requestItemsListValue.getKey());
                    jsonWriter.object();
                    ListWithAutoConstructFlag keysList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getKeys();
                    if (!(keysList == null || keysList.isAutoConstruct() && keysList.isEmpty())) {
                        jsonWriter.key("Keys");
                        jsonWriter.array();
                        for (Map keysListValue : keysList) {
                            if (keysListValue == null) continue;
                            jsonWriter.object();
                            for (Map.Entry memberListValue : keysListValue.entrySet()) {
                                ListWithAutoConstructFlag bSList;
                                ListWithAutoConstructFlag nSList;
                                ListWithAutoConstructFlag sSList;
                                if (memberListValue.getValue() == null) continue;
                                jsonWriter.key((String)memberListValue.getKey());
                                jsonWriter.object();
                                if (((AttributeValue)memberListValue.getValue()).getS() != null) {
                                    jsonWriter.key("S").value(((AttributeValue)memberListValue.getValue()).getS());
                                }
                                if (((AttributeValue)memberListValue.getValue()).getN() != null) {
                                    jsonWriter.key("N").value(((AttributeValue)memberListValue.getValue()).getN());
                                }
                                if (((AttributeValue)memberListValue.getValue()).getB() != null) {
                                    jsonWriter.key("B").value(((AttributeValue)memberListValue.getValue()).getB());
                                }
                                if (!((sSList = (ListWithAutoConstructFlag)((AttributeValue)memberListValue.getValue()).getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                                    jsonWriter.key("SS");
                                    jsonWriter.array();
                                    for (String sSListValue : sSList) {
                                        if (sSListValue == null) continue;
                                        jsonWriter.value(sSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                if (!((nSList = (ListWithAutoConstructFlag)((AttributeValue)memberListValue.getValue()).getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                                    jsonWriter.key("NS");
                                    jsonWriter.array();
                                    for (String nSListValue : nSList) {
                                        if (nSListValue == null) continue;
                                        jsonWriter.value(nSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                if (!((bSList = (ListWithAutoConstructFlag)((AttributeValue)memberListValue.getValue()).getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                                    jsonWriter.key("BS");
                                    jsonWriter.array();
                                    for (ByteBuffer bSListValue : bSList) {
                                        if (bSListValue == null) continue;
                                        jsonWriter.value(bSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((attributesToGetList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                        jsonWriter.key("AttributesToGet");
                        jsonWriter.array();
                        for (String attributesToGetListValue : attributesToGetList) {
                            if (attributesToGetListValue == null) continue;
                            jsonWriter.value(attributesToGetListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (requestItemsListValue.getValue().isConsistentRead() != null) {
                        jsonWriter.key("ConsistentRead").value(requestItemsListValue.getValue().isConsistentRead());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (batchGetItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(batchGetItemRequest.getReturnConsumedCapacity());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

