/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ConfirmConnectionRequestMarshaller
implements Marshaller<Request<ConfirmConnectionRequest>, ConfirmConnectionRequest> {
    @Override
    public Request<ConfirmConnectionRequest> marshall(ConfirmConnectionRequest confirmConnectionRequest) {
        if (confirmConnectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConfirmConnectionRequest> request = new DefaultRequest<ConfirmConnectionRequest>(confirmConnectionRequest, "AmazonDirectConnect");
        String target = "OvertureService.ConfirmConnection";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (confirmConnectionRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(confirmConnectionRequest.getConnectionId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

